/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.wrapper.Constants;

public class DES3SecretKey
extends SecretKey {
    protected ByteArrayAttribute value_;

    public DES3SecretKey() {
        this.keyType_.setLongValue(Key.KeyType.DES3);
    }

    protected DES3SecretKey(Session session, long l) {
        super(session, l);
        this.keyType_.setLongValue(Key.KeyType.DES3);
    }

    protected void allocateAttributes() {
        super.allocateAttributes();
        this.value_ = new ByteArrayAttribute(Attribute.VALUE);
        DES3SecretKey.putAttributesInTable(this);
    }

    public java.lang.Object clone() {
        DES3SecretKey dES3SecretKey = (DES3SecretKey)super.clone();
        dES3SecretKey.value_ = (ByteArrayAttribute)this.value_.clone();
        DES3SecretKey.putAttributesInTable(dES3SecretKey);
        return dES3SecretKey;
    }

    public boolean equals(java.lang.Object object) {
        boolean bl = false;
        if (object instanceof DES3SecretKey) {
            DES3SecretKey dES3SecretKey = (DES3SecretKey)object;
            bl = this == dES3SecretKey || super.equals(dES3SecretKey) && this.value_.equals(dES3SecretKey.value_);
        }
        return bl;
    }

    public static Object getInstance(Session session, long l) {
        return new DES3SecretKey(session, l);
    }

    public ByteArrayAttribute getValue() {
        return this.value_;
    }

    protected static void putAttributesInTable(DES3SecretKey dES3SecretKey) {
        if (dES3SecretKey == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        dES3SecretKey.attributeTable_.put(Attribute.VALUE, dES3SecretKey.value_);
    }

    public void readAttributes(Session session) {
        super.readAttributes(session);
        Object.getAttributeValue(session, this.objectHandle_, this.value_);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(super.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Value (hex): ");
        stringBuffer.append(this.value_.toString());
        return stringBuffer.toString();
    }
}

