/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.LongAttribute;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.wrapper.Constants;

public class CAST3SecretKey
extends SecretKey {
    protected ByteArrayAttribute value_;
    protected LongAttribute valueLen_;

    public CAST3SecretKey() {
        this.keyType_.setLongValue(Key.KeyType.CAST3);
    }

    protected CAST3SecretKey(Session session, long l) {
        super(session, l);
        this.keyType_.setLongValue(Key.KeyType.CAST3);
    }

    protected void allocateAttributes() {
        super.allocateAttributes();
        this.value_ = new ByteArrayAttribute(Attribute.VALUE);
        this.valueLen_ = new LongAttribute(Attribute.VALUE_LEN);
        CAST3SecretKey.putAttributesInTable(this);
    }

    public java.lang.Object clone() {
        CAST3SecretKey cAST3SecretKey = (CAST3SecretKey)super.clone();
        cAST3SecretKey.value_ = (ByteArrayAttribute)this.value_.clone();
        cAST3SecretKey.valueLen_ = (LongAttribute)this.valueLen_.clone();
        CAST3SecretKey.putAttributesInTable(cAST3SecretKey);
        return cAST3SecretKey;
    }

    public boolean equals(java.lang.Object object) {
        boolean bl = false;
        if (object instanceof CAST3SecretKey) {
            CAST3SecretKey cAST3SecretKey = (CAST3SecretKey)object;
            bl = this == cAST3SecretKey || super.equals(cAST3SecretKey) && this.value_.equals(cAST3SecretKey.value_) && this.valueLen_.equals(cAST3SecretKey.valueLen_);
        }
        return bl;
    }

    public static Object getInstance(Session session, long l) {
        return new CAST3SecretKey(session, l);
    }

    public ByteArrayAttribute getValue() {
        return this.value_;
    }

    public LongAttribute getValueLen() {
        return this.valueLen_;
    }

    protected static void putAttributesInTable(CAST3SecretKey cAST3SecretKey) {
        if (cAST3SecretKey == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        cAST3SecretKey.attributeTable_.put(Attribute.VALUE, cAST3SecretKey.value_);
        cAST3SecretKey.attributeTable_.put(Attribute.VALUE_LEN, cAST3SecretKey.valueLen_);
    }

    public void readAttributes(Session session) {
        super.readAttributes(session);
        Object.getAttributeValue(session, this.objectHandle_, this.value_);
        Object.getAttributeValue(session, this.objectHandle_, this.valueLen_);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(super.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Value (hex): ");
        stringBuffer.append(this.value_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Value Length (dec): ");
        stringBuffer.append(this.valueLen_.toString(10));
        return stringBuffer.toString();
    }
}

