/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.LongAttribute;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.wrapper.Constants;

public class BlowfishSecretKey
extends SecretKey {
    protected ByteArrayAttribute value_;
    protected LongAttribute valueLen_;

    public BlowfishSecretKey() {
        this.keyType_.setLongValue(Key.KeyType.GENERIC_SECRET);
    }

    protected BlowfishSecretKey(Session session, long l) {
        super(session, l);
        this.keyType_.setLongValue(Key.KeyType.GENERIC_SECRET);
    }

    protected void allocateAttributes() {
        super.allocateAttributes();
        this.value_ = new ByteArrayAttribute(Attribute.VALUE);
        this.valueLen_ = new LongAttribute(Attribute.VALUE_LEN);
        BlowfishSecretKey.putAttributesInTable(this);
    }

    public java.lang.Object clone() {
        BlowfishSecretKey blowfishSecretKey = (BlowfishSecretKey)super.clone();
        blowfishSecretKey.value_ = (ByteArrayAttribute)this.value_.clone();
        blowfishSecretKey.valueLen_ = (LongAttribute)this.valueLen_.clone();
        BlowfishSecretKey.putAttributesInTable(blowfishSecretKey);
        return blowfishSecretKey;
    }

    public boolean equals(java.lang.Object object) {
        boolean bl = false;
        if (object instanceof BlowfishSecretKey) {
            BlowfishSecretKey blowfishSecretKey = (BlowfishSecretKey)object;
            bl = this == blowfishSecretKey || super.equals(blowfishSecretKey) && this.value_.equals(blowfishSecretKey.value_) && this.valueLen_.equals(blowfishSecretKey.valueLen_);
        }
        return bl;
    }

    public static Object getInstance(Session session, long l) {
        return new BlowfishSecretKey(session, l);
    }

    public ByteArrayAttribute getValue() {
        return this.value_;
    }

    public LongAttribute getValueLen() {
        return this.valueLen_;
    }

    protected static void putAttributesInTable(BlowfishSecretKey blowfishSecretKey) {
        if (blowfishSecretKey == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        blowfishSecretKey.attributeTable_.put(Attribute.VALUE, blowfishSecretKey.value_);
        blowfishSecretKey.attributeTable_.put(Attribute.VALUE_LEN, blowfishSecretKey.valueLen_);
    }

    public void readAttributes(Session session) {
        super.readAttributes(session);
        Object.getAttributeValue(session, this.objectHandle_, this.value_);
        Object.getAttributeValue(session, this.objectHandle_, this.valueLen_);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(super.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Value (hex): ");
        stringBuffer.append(this.value_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Value Length (dec): ");
        stringBuffer.append(this.valueLen_.toString(10));
        return stringBuffer.toString();
    }
}

