/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.MechanismInfo;
import iaik.pkcs.pkcs11.Notify;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.Slot;
import iaik.pkcs.pkcs11.TokenInfo;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.wrapper.CK_MECHANISM_INFO;
import iaik.pkcs.pkcs11.wrapper.CK_NOTIFY;
import iaik.pkcs.pkcs11.wrapper.CK_TOKEN_INFO;

public class Token {
    protected Slot slot_;

    protected Token(Slot slot) {
        if (slot == null) {
            throw new NullPointerException("Argument \"slot\" must not be null.");
        }
        this.slot_ = slot;
    }

    public void closeAllSessions() {
        this.slot_.getModule().getPKCS11Module().C_CloseAllSessions(this.slot_.getSlotID());
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Token) {
            Token token = (Token)object;
            bl = this == token || this.slot_.equals(token.slot_);
        }
        return bl;
    }

    public MechanismInfo getMechanismInfo(Mechanism mechanism) {
        long l = mechanism.getMechanismCode();
        CK_MECHANISM_INFO cK_MECHANISM_INFO = this.slot_.getModule().getPKCS11Module().C_GetMechanismInfo(this.slot_.getSlotID(), l);
        return new MechanismInfo(cK_MECHANISM_INFO);
    }

    public Mechanism[] getMechanismList() {
        long[] lArray = this.slot_.getModule().getPKCS11Module().C_GetMechanismList(this.slot_.getSlotID());
        Mechanism[] mechanismArray = new Mechanism[lArray.length];
        int n = 0;
        while (n < mechanismArray.length) {
            mechanismArray[n] = new Mechanism(lArray[n]);
            ++n;
        }
        return mechanismArray;
    }

    public Slot getSlot() {
        return this.slot_;
    }

    public long getTokenID() {
        return this.slot_.getSlotID();
    }

    public TokenInfo getTokenInfo() {
        CK_TOKEN_INFO cK_TOKEN_INFO = this.slot_.getModule().getPKCS11Module().C_GetTokenInfo(this.slot_.getSlotID());
        return new TokenInfo(cK_TOKEN_INFO);
    }

    public int hashCode() {
        return this.slot_.hashCode();
    }

    public void initToken(char[] cArray, String string) {
        char[] cArray2 = Util.toPaddedCharArray(string, 32, ' ');
        this.slot_.getModule().getPKCS11Module().C_InitToken(this.slot_.getSlotID(), cArray, cArray2);
    }

    public Session openSession(boolean bl, boolean bl2, Object object, Notify notify) {
        long l;
        long l2 = 0L;
        l2 |= bl ? 4L : 0L;
        l2 |= bl2 ? 2L : 0L;
        Session session = new Session(this, -1L);
        CK_NOTIFY cK_NOTIFY = null;
        if (notify != null) {
            cK_NOTIFY = new CK_NOTIFY(session, notify){
                private final Session wv;
                private final Notify ww;
                {
                    this.wv = session;
                    this.ww = notify;
                }

                public void CK_NOTIFY(long l, long l2, Object object) {
                    boolean bl = 0L != 0L;
                    this.ww.notify(this.wv, bl, object);
                }
            };
        }
        session.sessionHandle_ = l = this.slot_.getModule().getPKCS11Module().C_OpenSession(this.slot_.getSlotID(), l2, object, cK_NOTIFY);
        return session;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Token in Slot: ");
        stringBuffer.append(this.slot_.toString());
        return stringBuffer.toString();
    }

    public static interface SessionType {
        public static final boolean PARALLEL_SESSION = false;
        public static final boolean SERIAL_SESSION = true;
    }

    public static interface SessionReadWriteBehavior {
        public static final boolean RO_SESSION = false;
        public static final boolean RW_SESSION = true;
    }
}

