/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11;

import iaik.pkcs.pkcs11.Module;
import iaik.pkcs.pkcs11.SlotInfo;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.wrapper.CK_SLOT_INFO;
import iaik.pkcs.pkcs11.wrapper.Constants;
import iaik.pkcs.pkcs11.wrapper.Functions;

public class Slot {
    protected Module module_;
    protected long slotID_;

    protected Slot(Module module, long l) {
        if (module == null) {
            throw new NullPointerException("Argument \"module\" must not be null.");
        }
        this.module_ = module;
        this.slotID_ = l;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Slot) {
            Slot slot = (Slot)object;
            bl = this == slot || this.slotID_ == slot.slotID_ && this.module_.equals(slot.module_);
        }
        return bl;
    }

    public Module getModule() {
        return this.module_;
    }

    public long getSlotID() {
        return this.slotID_;
    }

    public SlotInfo getSlotInfo() {
        CK_SLOT_INFO cK_SLOT_INFO = this.module_.getPKCS11Module().C_GetSlotInfo(this.slotID_);
        return new SlotInfo(cK_SLOT_INFO);
    }

    public Token getToken() {
        Token token = null;
        if (this.getSlotInfo().isTokenPresent()) {
            token = new Token(this);
        }
        return token;
    }

    public int hashCode() {
        return (int)this.slotID_;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Slot ID: ");
        stringBuffer.append("0x");
        stringBuffer.append(Functions.toHexString(this.slotID_));
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("Module: ");
        stringBuffer.append(this.module_.toString());
        return stringBuffer.toString();
    }
}

