/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.Module;
import iaik.pkcs.pkcs11.SessionInfo;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.KeyPair;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.objects.PrivateKey;
import iaik.pkcs.pkcs11.objects.PublicKey;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.parameters.Parameters;
import iaik.pkcs.pkcs11.parameters.SSL3KeyMaterialParameters;
import iaik.pkcs.pkcs11.parameters.SSL3MasterKeyDeriveParameters;
import iaik.pkcs.pkcs11.wrapper.CK_ATTRIBUTE;
import iaik.pkcs.pkcs11.wrapper.CK_MECHANISM;
import iaik.pkcs.pkcs11.wrapper.CK_SESSION_INFO;
import iaik.pkcs.pkcs11.wrapper.CK_SSL3_KEY_MAT_PARAMS;
import iaik.pkcs.pkcs11.wrapper.CK_SSL3_MASTER_KEY_DERIVE_PARAMS;
import iaik.pkcs.pkcs11.wrapper.Constants;
import iaik.pkcs.pkcs11.wrapper.Functions;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import java.util.Vector;

public class Session {
    protected Module module_;
    protected PKCS11 pkcs11Module_;
    protected long sessionHandle_;
    protected Token token_;

    protected Session(Token token, long l) {
        if (token == null) {
            throw new NullPointerException("Argument \"token\" must not be null.");
        }
        this.token_ = token;
        this.module_ = this.token_.getSlot().getModule();
        this.pkcs11Module_ = this.module_.getPKCS11Module();
        this.sessionHandle_ = l;
    }

    public void cancelFunction() {
        this.pkcs11Module_.C_CancelFunction(this.sessionHandle_);
    }

    public void closeSession() {
        this.pkcs11Module_.C_CloseSession(this.sessionHandle_);
    }

    public Object copyObject(Object object, Object object2) {
        long l = object.getObjectHandle();
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = Object.getSetAttributes(object2);
        long l2 = this.pkcs11Module_.C_CopyObject(this.sessionHandle_, l, cK_ATTRIBUTEArray);
        return Object.getInstance(this, l2);
    }

    public Object createObject(Object object) {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = Object.getSetAttributes(object);
        long l = this.pkcs11Module_.C_CreateObject(this.sessionHandle_, cK_ATTRIBUTEArray);
        return Object.getInstance(this, l);
    }

    public byte[] decrypt(byte[] byArray) {
        return this.pkcs11Module_.C_Decrypt(this.sessionHandle_, byArray);
    }

    public byte[] decryptDigestUpdate(byte[] byArray) {
        return this.pkcs11Module_.C_DecryptDigestUpdate(this.sessionHandle_, byArray);
    }

    public byte[] decryptFinal() {
        return this.pkcs11Module_.C_DecryptFinal(this.sessionHandle_);
    }

    public void decryptInit(Mechanism mechanism, Key key) {
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM();
        cK_MECHANISM.mechanism = mechanism.getMechanismCode();
        Parameters parameters = mechanism.getParameters();
        cK_MECHANISM.pParameter = parameters != null ? parameters.getPKCS11ParamsObject() : null;
        this.pkcs11Module_.C_DecryptInit(this.sessionHandle_, cK_MECHANISM, key.getObjectHandle());
    }

    public byte[] decryptUpdate(byte[] byArray) {
        return this.pkcs11Module_.C_DecryptUpdate(this.sessionHandle_, byArray);
    }

    public byte[] decryptVerifyUpdate(byte[] byArray) {
        return this.pkcs11Module_.C_DecryptVerifyUpdate(this.sessionHandle_, byArray);
    }

    public Key deriveKey(Mechanism mechanism, Key key, Key key2) {
        Key key3 = null;
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM();
        cK_MECHANISM.mechanism = mechanism.getMechanismCode();
        Parameters parameters = mechanism.getParameters();
        cK_MECHANISM.pParameter = parameters != null ? parameters.getPKCS11ParamsObject() : null;
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = Object.getSetAttributes(key2);
        long l = this.pkcs11Module_.C_DeriveKey(this.sessionHandle_, cK_MECHANISM, key.getObjectHandle(), cK_ATTRIBUTEArray);
        if (cK_MECHANISM.mechanism == 881L && parameters instanceof SSL3MasterKeyDeriveParameters) {
            ((SSL3MasterKeyDeriveParameters)parameters).getVersion().setPKCS11ParamsObject(((CK_SSL3_MASTER_KEY_DERIVE_PARAMS)cK_MECHANISM.pParameter).pVersion);
            key3 = (Key)Object.getInstance(this, l);
        } else if (cK_MECHANISM.mechanism == 882L && parameters instanceof SSL3KeyMaterialParameters) {
            ((SSL3KeyMaterialParameters)parameters).getReturnedKeyMaterial().setPKCS11ParamsObject(((CK_SSL3_KEY_MAT_PARAMS)cK_MECHANISM.pParameter).pReturnedKeyMaterial, this);
            key3 = null;
        } else {
            key3 = (Key)Object.getInstance(this, l);
        }
        return key3;
    }

    public void destroyObject(Object object) {
        long l = object.getObjectHandle();
        this.pkcs11Module_.C_DestroyObject(this.sessionHandle_, l);
    }

    public byte[] digest(byte[] byArray) {
        return this.pkcs11Module_.C_Digest(this.sessionHandle_, byArray);
    }

    public byte[] digestEncryptedUpdate(byte[] byArray) {
        return this.pkcs11Module_.C_DigestEncryptUpdate(this.sessionHandle_, byArray);
    }

    public byte[] digestFinal() {
        return this.pkcs11Module_.C_DigestFinal(this.sessionHandle_);
    }

    public void digestInit(Mechanism mechanism) {
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM();
        cK_MECHANISM.mechanism = mechanism.getMechanismCode();
        Parameters parameters = mechanism.getParameters();
        cK_MECHANISM.pParameter = parameters != null ? parameters.getPKCS11ParamsObject() : null;
        this.pkcs11Module_.C_DigestInit(this.sessionHandle_, cK_MECHANISM);
    }

    public void digestKey(SecretKey secretKey) {
        this.pkcs11Module_.C_DigestKey(this.sessionHandle_, secretKey.getObjectHandle());
    }

    public void digestUpdate(byte[] byArray) {
        this.pkcs11Module_.C_DigestUpdate(this.sessionHandle_, byArray);
    }

    public byte[] encrypt(byte[] byArray) {
        return this.pkcs11Module_.C_Encrypt(this.sessionHandle_, byArray);
    }

    public byte[] encryptFinal() {
        return this.pkcs11Module_.C_EncryptFinal(this.sessionHandle_);
    }

    public void encryptInit(Mechanism mechanism, Key key) {
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM();
        cK_MECHANISM.mechanism = mechanism.getMechanismCode();
        Parameters parameters = mechanism.getParameters();
        cK_MECHANISM.pParameter = parameters != null ? parameters.getPKCS11ParamsObject() : null;
        this.pkcs11Module_.C_EncryptInit(this.sessionHandle_, cK_MECHANISM, key.getObjectHandle());
    }

    public byte[] encryptUpdate(byte[] byArray) {
        return this.pkcs11Module_.C_EncryptUpdate(this.sessionHandle_, byArray);
    }

    public boolean equals(java.lang.Object object) {
        boolean bl = false;
        if (object instanceof Session) {
            Session session = (Session)object;
            bl = this == session || this.sessionHandle_ == session.sessionHandle_ && this.token_.equals(session.token_);
        }
        return bl;
    }

    public Object[] findObjects(int n) {
        java.lang.Object object;
        Vector<java.lang.Object[]> vector = new Vector<java.lang.Object[]>();
        long[] lArray = this.pkcs11Module_.C_FindObjects(this.sessionHandle_, n);
        int n2 = 0;
        while (n2 < lArray.length) {
            object = Object.getInstance(this, lArray[n2]);
            vector.addElement((java.lang.Object[])object);
            ++n2;
        }
        object = new Object[vector.size()];
        vector.copyInto((java.lang.Object[])object);
        return object;
    }

    public void findObjectsFinal() {
        this.pkcs11Module_.C_FindObjectsFinal(this.sessionHandle_);
    }

    public void findObjectsInit(Object object) {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = Object.getSetAttributes(object);
        this.pkcs11Module_.C_FindObjectsInit(this.sessionHandle_, cK_ATTRIBUTEArray);
    }

    public Object generateKey(Mechanism mechanism, Object object) {
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM();
        cK_MECHANISM.mechanism = mechanism.getMechanismCode();
        Parameters parameters = mechanism.getParameters();
        cK_MECHANISM.pParameter = parameters != null ? parameters.getPKCS11ParamsObject() : null;
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = Object.getSetAttributes(object);
        long l = this.pkcs11Module_.C_GenerateKey(this.sessionHandle_, cK_MECHANISM, cK_ATTRIBUTEArray);
        return Object.getInstance(this, l);
    }

    public KeyPair generateKeyPair(Mechanism mechanism, Object object, Object object2) {
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM();
        cK_MECHANISM.mechanism = mechanism.getMechanismCode();
        Parameters parameters = mechanism.getParameters();
        cK_MECHANISM.pParameter = parameters != null ? parameters.getPKCS11ParamsObject() : null;
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = Object.getSetAttributes(object);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = Object.getSetAttributes(object2);
        long[] lArray = this.pkcs11Module_.C_GenerateKeyPair(this.sessionHandle_, cK_MECHANISM, cK_ATTRIBUTEArray, cK_ATTRIBUTEArray2);
        PublicKey publicKey = (PublicKey)Object.getInstance(this, lArray[0]);
        PrivateKey privateKey = (PrivateKey)Object.getInstance(this, lArray[1]);
        return new KeyPair(publicKey, privateKey);
    }

    public byte[] generateRandom(int n) {
        byte[] byArray = new byte[n];
        this.pkcs11Module_.C_GenerateRandom(this.sessionHandle_, byArray);
        return byArray;
    }

    public Object getAttributeValues(Object object) {
        long l = object.getObjectHandle();
        return Object.getInstance(this, l);
    }

    public void getFunctionStatus() {
        this.pkcs11Module_.C_GetFunctionStatus(this.sessionHandle_);
    }

    public Module getModule() {
        return this.module_;
    }

    public long getObjectSize(Object object) {
        long l = object.getObjectHandle();
        return this.pkcs11Module_.C_GetObjectSize(this.sessionHandle_, l);
    }

    public byte[] getOperationState() {
        return this.pkcs11Module_.C_GetOperationState(this.sessionHandle_);
    }

    public long getSessionHandle() {
        return this.sessionHandle_;
    }

    public SessionInfo getSessionInfo() {
        CK_SESSION_INFO cK_SESSION_INFO = this.pkcs11Module_.C_GetSessionInfo(this.sessionHandle_);
        return new SessionInfo(cK_SESSION_INFO);
    }

    public Token getToken() {
        return this.token_;
    }

    public int hashCode() {
        return (int)this.sessionHandle_;
    }

    public void initPIN(char[] cArray) {
        this.pkcs11Module_.C_InitPIN(this.sessionHandle_, cArray);
    }

    public void login(boolean bl, char[] cArray) {
        long l = !bl ? 0L : 1L;
        this.pkcs11Module_.C_Login(this.sessionHandle_, l, cArray);
    }

    public void logout() {
        this.pkcs11Module_.C_Logout(this.sessionHandle_);
    }

    public void seedRandom(byte[] byArray) {
        this.pkcs11Module_.C_SeedRandom(this.sessionHandle_, byArray);
    }

    public void setAttributeValues(Object object, Object object2) {
        long l = object.getObjectHandle();
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = Object.getSetAttributes(object2);
        this.pkcs11Module_.C_SetAttributeValue(this.sessionHandle_, l, cK_ATTRIBUTEArray);
    }

    public void setOperationState(byte[] byArray, Key key, Key key2) {
        this.pkcs11Module_.C_SetOperationState(this.sessionHandle_, byArray, key.getObjectHandle(), key2.getObjectHandle());
    }

    public void setPIN(char[] cArray, char[] cArray2) {
        this.pkcs11Module_.C_SetPIN(this.sessionHandle_, cArray, cArray2);
    }

    public byte[] sign(byte[] byArray) {
        return this.pkcs11Module_.C_Sign(this.sessionHandle_, byArray);
    }

    public byte[] signEncryptUpdate(byte[] byArray) {
        return this.pkcs11Module_.C_SignEncryptUpdate(this.sessionHandle_, byArray);
    }

    public byte[] signFinal() {
        return this.pkcs11Module_.C_SignFinal(this.sessionHandle_);
    }

    public void signInit(Mechanism mechanism, Key key) {
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM();
        cK_MECHANISM.mechanism = mechanism.getMechanismCode();
        Parameters parameters = mechanism.getParameters();
        cK_MECHANISM.pParameter = parameters != null ? parameters.getPKCS11ParamsObject() : null;
        this.pkcs11Module_.C_SignInit(this.sessionHandle_, cK_MECHANISM, key.getObjectHandle());
    }

    public byte[] signRecover(byte[] byArray) {
        return this.pkcs11Module_.C_SignRecover(this.sessionHandle_, byArray);
    }

    public void signRecoverInit(Mechanism mechanism, Key key) {
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM();
        cK_MECHANISM.mechanism = mechanism.getMechanismCode();
        Parameters parameters = mechanism.getParameters();
        cK_MECHANISM.pParameter = parameters != null ? parameters.getPKCS11ParamsObject() : null;
        this.pkcs11Module_.C_SignRecoverInit(this.sessionHandle_, cK_MECHANISM, key.getObjectHandle());
    }

    public void signUpdate(byte[] byArray) {
        this.pkcs11Module_.C_SignUpdate(this.sessionHandle_, byArray);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Session Handle: ");
        stringBuffer.append("0x");
        stringBuffer.append(Functions.toHexString(this.sessionHandle_));
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("Token: ");
        stringBuffer.append(this.token_.toString());
        return stringBuffer.toString();
    }

    public Key unwrapKey(Mechanism mechanism, Key key, byte[] byArray, Object object) {
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM();
        cK_MECHANISM.mechanism = mechanism.getMechanismCode();
        Parameters parameters = mechanism.getParameters();
        cK_MECHANISM.pParameter = parameters != null ? parameters.getPKCS11ParamsObject() : null;
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = Object.getSetAttributes(object);
        long l = this.pkcs11Module_.C_UnwrapKey(this.sessionHandle_, cK_MECHANISM, key.getObjectHandle(), byArray, cK_ATTRIBUTEArray);
        return (Key)Object.getInstance(this, l);
    }

    public void verify(byte[] byArray, byte[] byArray2) {
        this.pkcs11Module_.C_Verify(this.sessionHandle_, byArray, byArray2);
    }

    public void verifyFinal(byte[] byArray) {
        this.pkcs11Module_.C_VerifyFinal(this.sessionHandle_, byArray);
    }

    public void verifyInit(Mechanism mechanism, Key key) {
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM();
        cK_MECHANISM.mechanism = mechanism.getMechanismCode();
        Parameters parameters = mechanism.getParameters();
        cK_MECHANISM.pParameter = parameters != null ? parameters.getPKCS11ParamsObject() : null;
        this.pkcs11Module_.C_VerifyInit(this.sessionHandle_, cK_MECHANISM, key.getObjectHandle());
    }

    public byte[] verifyRecover(byte[] byArray) {
        return this.pkcs11Module_.C_VerifyRecover(this.sessionHandle_, byArray);
    }

    public void verifyRecoverInit(Mechanism mechanism, Key key) {
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM();
        cK_MECHANISM.mechanism = mechanism.getMechanismCode();
        Parameters parameters = mechanism.getParameters();
        cK_MECHANISM.pParameter = parameters != null ? parameters.getPKCS11ParamsObject() : null;
        this.pkcs11Module_.C_VerifyRecoverInit(this.sessionHandle_, cK_MECHANISM, key.getObjectHandle());
    }

    public void verifyUpdate(byte[] byArray) {
        this.pkcs11Module_.C_VerifyUpdate(this.sessionHandle_, byArray);
    }

    public byte[] wrapKey(Mechanism mechanism, Key key, Key key2) {
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM();
        cK_MECHANISM.mechanism = mechanism.getMechanismCode();
        Parameters parameters = mechanism.getParameters();
        cK_MECHANISM.pParameter = parameters != null ? parameters.getPKCS11ParamsObject() : null;
        return this.pkcs11Module_.C_WrapKey(this.sessionHandle_, cK_MECHANISM, key.getObjectHandle(), key2.getObjectHandle());
    }

    public static interface UserType {
        public static final boolean SO = false;
        public static final boolean USER = true;
    }
}

