/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.search;

import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.search.SearchTerm;

public final class FlagTerm
extends SearchTerm {
    protected boolean set;
    protected Flags flags;
    private static final long serialVersionUID = -142991500302030647L;

    public FlagTerm(Flags flags, boolean bl) {
        this.flags = flags;
        this.set = bl;
    }

    public Flags getFlags() {
        return (Flags)this.flags.clone();
    }

    public boolean getTestSet() {
        return this.set;
    }

    public boolean match(Message message) {
        try {
            Flags flags = message.getFlags();
            if (this.set) {
                return flags.contains(this.flags);
            }
            Flags.Flag[] flagArray = this.flags.getSystemFlags();
            for (int i2 = 0; i2 < flagArray.length; ++i2) {
                if (!flags.contains(flagArray[i2])) continue;
                return false;
            }
            String[] stringArray = this.flags.getUserFlags();
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                if (!flags.contains(stringArray[i3])) continue;
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof FlagTerm)) {
            return false;
        }
        FlagTerm flagTerm = (FlagTerm)object;
        return flagTerm.set == this.set && flagTerm.flags.equals(this.flags);
    }

    public int hashCode() {
        return this.set ? this.flags.hashCode() : ~this.flags.hashCode();
    }
}

