/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import com.b.b.a.f;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.UnknownServiceException;
import javax.activation.DataSource;
import javax.mail.FolderClosedException;
import javax.mail.MessageAware;
import javax.mail.MessageContext;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimeUtility;

public class MimePartDataSource
implements DataSource,
MessageAware {
    protected MimePart part;
    private MessageContext context;

    public MimePartDataSource(MimePart mimePart) {
        this.part = mimePart;
    }

    public InputStream getInputStream() {
        try {
            InputStream inputStream;
            if (this.part instanceof MimeBodyPart) {
                inputStream = ((MimeBodyPart)this.part).getContentStream();
            } else if (this.part instanceof MimeMessage) {
                inputStream = ((MimeMessage)this.part).getContentStream();
            } else {
                throw new MessagingException("Unknown part");
            }
            String string = MimeBodyPart.restrictEncoding(this.part, this.part.getEncoding());
            if (string != null) {
                return MimeUtility.decode(inputStream, string);
            }
            return inputStream;
        }
        catch (FolderClosedException folderClosedException) {
            throw new f(folderClosedException.getFolder(), folderClosedException.getMessage());
        }
        catch (MessagingException messagingException) {
            throw new IOException(messagingException.getMessage());
        }
    }

    public OutputStream getOutputStream() {
        throw new UnknownServiceException("Writing not supported");
    }

    public String getContentType() {
        try {
            return this.part.getContentType();
        }
        catch (MessagingException messagingException) {
            return "application/octet-stream";
        }
    }

    public String getName() {
        try {
            if (this.part instanceof MimeBodyPart) {
                return ((MimeBodyPart)this.part).getFileName();
            }
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        return "";
    }

    public synchronized MessageContext getMessageContext() {
        if (this.context == null) {
            this.context = new MessageContext(this.part);
        }
        return this.context;
    }
}

