/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import com.b.b.a.a;
import com.b.b.a.f;
import com.b.b.a.h;
import com.b.b.a.i;
import com.b.b.a.j;
import com.b.b.a.l;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.FolderClosedException;
import javax.mail.Message;
import javax.mail.MessageRemovedException;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MailDateFormat;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimePartDataSource;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.NewsAddress;
import javax.mail.internet.SharedInputStream;
import javax.mail.internet.UniqueValue;
import javax.mail.util.SharedByteArrayInputStream;

public class MimeMessage
extends Message
implements MimePart {
    protected DataHandler dh;
    protected byte[] content;
    protected InputStream contentStream;
    protected InternetHeaders headers;
    protected Flags flags;
    protected boolean modified = false;
    protected boolean saved = false;
    Object cachedContent;
    private static final MailDateFormat mailDateFormat = new MailDateFormat();
    private boolean strict = true;
    private static final Flags answeredFlag = new Flags(Flags.Flag.ANSWERED);

    public MimeMessage(Session session) {
        super(session);
        this.modified = true;
        this.headers = new InternetHeaders();
        this.flags = new Flags();
        this.initStrict();
    }

    public MimeMessage(Session session, InputStream inputStream) {
        super(session);
        this.flags = new Flags();
        this.initStrict();
        this.parse(inputStream);
        this.saved = true;
    }

    public MimeMessage(MimeMessage mimeMessage) {
        super(mimeMessage.session);
        int n2;
        this.flags = mimeMessage.getFlags();
        if (this.flags == null) {
            this.flags = new Flags();
        }
        ByteArrayOutputStream byteArrayOutputStream = (n2 = mimeMessage.getSize()) > 0 ? new ByteArrayOutputStream(n2) : new ByteArrayOutputStream();
        try {
            this.strict = mimeMessage.strict;
            mimeMessage.writeTo(byteArrayOutputStream);
            byteArrayOutputStream.close();
            SharedByteArrayInputStream sharedByteArrayInputStream = new SharedByteArrayInputStream(byteArrayOutputStream.toByteArray());
            this.parse(sharedByteArrayInputStream);
            sharedByteArrayInputStream.close();
            this.saved = true;
        }
        catch (IOException iOException) {
            throw new MessagingException("IOException while copying message", iOException);
        }
    }

    protected MimeMessage(Folder folder, int n2) {
        super(folder, n2);
        this.flags = new Flags();
        this.saved = true;
        this.initStrict();
    }

    protected MimeMessage(Folder folder, InputStream inputStream, int n2) {
        this(folder, n2);
        this.initStrict();
        this.parse(inputStream);
    }

    protected MimeMessage(Folder folder, InternetHeaders internetHeaders, byte[] byArray, int n2) {
        this(folder, n2);
        this.headers = internetHeaders;
        this.content = byArray;
        this.initStrict();
    }

    private void initStrict() {
        if (this.session != null) {
            this.strict = l.getBooleanSessionProperty(this.session, "mail.mime.address.strict", true);
        }
    }

    protected void parse(InputStream inputStream) {
        if (!(inputStream instanceof ByteArrayInputStream || inputStream instanceof BufferedInputStream || inputStream instanceof SharedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        this.headers = this.createInternetHeaders(inputStream);
        if (inputStream instanceof SharedInputStream) {
            SharedInputStream sharedInputStream = (SharedInputStream)((Object)inputStream);
            this.contentStream = sharedInputStream.newStream(sharedInputStream.getPosition(), -1L);
        } else {
            try {
                this.content = a.getBytes(inputStream);
            }
            catch (IOException iOException) {
                throw new MessagingException("IOException", iOException);
            }
        }
        this.modified = false;
    }

    public Address[] getFrom() {
        Address[] addressArray = this.getAddressHeader("From");
        if (addressArray == null) {
            addressArray = this.getAddressHeader("Sender");
        }
        return addressArray;
    }

    public void setFrom(Address address) {
        if (address == null) {
            this.removeHeader("From");
        } else {
            this.setHeader("From", address.toString());
        }
    }

    public void setFrom() {
        InternetAddress internetAddress = null;
        try {
            internetAddress = InternetAddress._getLocalAddress(this.session);
        }
        catch (Exception exception) {
            throw new MessagingException("No From address", exception);
        }
        if (internetAddress == null) {
            throw new MessagingException("No From address");
        }
        this.setFrom(internetAddress);
    }

    public void addFrom(Address[] addressArray) {
        this.addAddressHeader("From", addressArray);
    }

    public Address getSender() {
        Address[] addressArray = this.getAddressHeader("Sender");
        if (addressArray == null || addressArray.length == 0) {
            return null;
        }
        return addressArray[0];
    }

    public void setSender(Address address) {
        if (address == null) {
            this.removeHeader("Sender");
        } else {
            this.setHeader("Sender", address.toString());
        }
    }

    public Address[] getRecipients(Message.RecipientType recipientType) {
        if (recipientType == RecipientType.NEWSGROUPS) {
            String string = this.getHeader("Newsgroups", ",");
            return string == null ? null : NewsAddress.parse(string);
        }
        return this.getAddressHeader(this.getHeaderName(recipientType));
    }

    public Address[] getAllRecipients() {
        Address[] addressArray = super.getAllRecipients();
        Address[] addressArray2 = this.getRecipients(RecipientType.NEWSGROUPS);
        if (addressArray2 == null) {
            return addressArray;
        }
        if (addressArray == null) {
            return addressArray2;
        }
        Address[] addressArray3 = new Address[addressArray.length + addressArray2.length];
        System.arraycopy(addressArray, 0, addressArray3, 0, addressArray.length);
        System.arraycopy(addressArray2, 0, addressArray3, addressArray.length, addressArray2.length);
        return addressArray3;
    }

    public void setRecipients(Message.RecipientType recipientType, Address[] addressArray) {
        if (recipientType == RecipientType.NEWSGROUPS) {
            if (addressArray == null || addressArray.length == 0) {
                this.removeHeader("Newsgroups");
            } else {
                this.setHeader("Newsgroups", NewsAddress.toString(addressArray));
            }
        } else {
            this.setAddressHeader(this.getHeaderName(recipientType), addressArray);
        }
    }

    public void setRecipients(Message.RecipientType recipientType, String string) {
        if (recipientType == RecipientType.NEWSGROUPS) {
            if (string == null || string.length() == 0) {
                this.removeHeader("Newsgroups");
            } else {
                this.setHeader("Newsgroups", string);
            }
        } else {
            this.setAddressHeader(this.getHeaderName(recipientType), string == null ? null : InternetAddress.parse(string));
        }
    }

    public void addRecipients(Message.RecipientType recipientType, Address[] addressArray) {
        if (recipientType == RecipientType.NEWSGROUPS) {
            String string = NewsAddress.toString(addressArray);
            if (string != null) {
                this.addHeader("Newsgroups", string);
            }
        } else {
            this.addAddressHeader(this.getHeaderName(recipientType), addressArray);
        }
    }

    public void addRecipients(Message.RecipientType recipientType, String string) {
        if (recipientType == RecipientType.NEWSGROUPS) {
            if (string != null && string.length() != 0) {
                this.addHeader("Newsgroups", string);
            }
        } else {
            this.addAddressHeader(this.getHeaderName(recipientType), InternetAddress.parse(string));
        }
    }

    public Address[] getReplyTo() {
        Address[] addressArray = this.getAddressHeader("Reply-To");
        if (addressArray == null || addressArray.length == 0) {
            addressArray = this.getFrom();
        }
        return addressArray;
    }

    public void setReplyTo(Address[] addressArray) {
        this.setAddressHeader("Reply-To", addressArray);
    }

    private Address[] getAddressHeader(String string) {
        String string2 = this.getHeader(string, ",");
        return string2 == null ? null : InternetAddress.parseHeader(string2, this.strict);
    }

    private void setAddressHeader(String string, Address[] addressArray) {
        String string2 = InternetAddress.toString(addressArray);
        if (string2 == null) {
            this.removeHeader(string);
        } else {
            this.setHeader(string, string2);
        }
    }

    private void addAddressHeader(String string, Address[] addressArray) {
        Address[] addressArray2;
        if (addressArray == null || addressArray.length == 0) {
            return;
        }
        Address[] addressArray3 = this.getAddressHeader(string);
        if (addressArray3 == null || addressArray3.length == 0) {
            addressArray2 = addressArray;
        } else {
            addressArray2 = new Address[addressArray3.length + addressArray.length];
            System.arraycopy(addressArray3, 0, addressArray2, 0, addressArray3.length);
            System.arraycopy(addressArray, 0, addressArray2, addressArray3.length, addressArray.length);
        }
        String string2 = InternetAddress.toString(addressArray2);
        if (string2 == null) {
            return;
        }
        this.setHeader(string, string2);
    }

    public String getSubject() {
        String string = this.getHeader("Subject", null);
        if (string == null) {
            return null;
        }
        try {
            return MimeUtility.decodeText(MimeUtility.unfold(string));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    public void setSubject(String string) {
        this.setSubject(string, null);
    }

    public void setSubject(String string, String string2) {
        if (string == null) {
            this.removeHeader("Subject");
        } else {
            try {
                this.setHeader("Subject", MimeUtility.fold(9, MimeUtility.encodeText(string, string2, null)));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new MessagingException("Encoding error", unsupportedEncodingException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getSentDate() {
        String string = this.getHeader("Date", null);
        if (string != null) {
            try {
                MailDateFormat mailDateFormat = MimeMessage.mailDateFormat;
                synchronized (mailDateFormat) {
                    return MimeMessage.mailDateFormat.parse(string);
                }
            }
            catch (ParseException parseException) {
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSentDate(Date date) {
        if (date == null) {
            this.removeHeader("Date");
        } else {
            MailDateFormat mailDateFormat = MimeMessage.mailDateFormat;
            synchronized (mailDateFormat) {
                this.setHeader("Date", MimeMessage.mailDateFormat.format(date));
            }
        }
    }

    public Date getReceivedDate() {
        return null;
    }

    public int getSize() {
        if (this.content != null) {
            return this.content.length;
        }
        if (this.contentStream != null) {
            try {
                int n2 = this.contentStream.available();
                if (n2 > 0) {
                    return n2;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return -1;
    }

    public int getLineCount() {
        return -1;
    }

    public String getContentType() {
        String string = this.getHeader("Content-Type", null);
        if ((string = j.cleanContentType(this, string)) == null) {
            return "text/plain";
        }
        return string;
    }

    public boolean isMimeType(String string) {
        return MimeBodyPart.isMimeType(this, string);
    }

    public String getDisposition() {
        return MimeBodyPart.getDisposition(this);
    }

    public void setDisposition(String string) {
        MimeBodyPart.setDisposition(this, string);
    }

    public String getEncoding() {
        return MimeBodyPart.getEncoding(this);
    }

    public String getContentID() {
        return this.getHeader("Content-Id", null);
    }

    public void setContentID(String string) {
        if (string == null) {
            this.removeHeader("Content-ID");
        } else {
            this.setHeader("Content-ID", string);
        }
    }

    public String getContentMD5() {
        return this.getHeader("Content-MD5", null);
    }

    public void setContentMD5(String string) {
        this.setHeader("Content-MD5", string);
    }

    public String getDescription() {
        return MimeBodyPart.getDescription(this);
    }

    public void setDescription(String string) {
        this.setDescription(string, null);
    }

    public void setDescription(String string, String string2) {
        MimeBodyPart.setDescription(this, string, string2);
    }

    public String[] getContentLanguage() {
        return MimeBodyPart.getContentLanguage(this);
    }

    public void setContentLanguage(String[] stringArray) {
        MimeBodyPart.setContentLanguage(this, stringArray);
    }

    public String getMessageID() {
        return this.getHeader("Message-ID", null);
    }

    public String getFileName() {
        return MimeBodyPart.getFileName(this);
    }

    public void setFileName(String string) {
        MimeBodyPart.setFileName(this, string);
    }

    private String getHeaderName(Message.RecipientType recipientType) {
        String string;
        if (recipientType == Message.RecipientType.TO) {
            string = "To";
        } else if (recipientType == Message.RecipientType.CC) {
            string = "Cc";
        } else if (recipientType == Message.RecipientType.BCC) {
            string = "Bcc";
        } else if (recipientType == RecipientType.NEWSGROUPS) {
            string = "Newsgroups";
        } else {
            throw new MessagingException("Invalid Recipient Type");
        }
        return string;
    }

    public InputStream getInputStream() {
        return this.getDataHandler().getInputStream();
    }

    protected InputStream getContentStream() {
        if (this.contentStream != null) {
            return ((SharedInputStream)((Object)this.contentStream)).newStream(0L, -1L);
        }
        if (this.content != null) {
            return new SharedByteArrayInputStream(this.content);
        }
        throw new MessagingException("No MimeMessage content");
    }

    public InputStream getRawInputStream() {
        return this.getContentStream();
    }

    public synchronized DataHandler getDataHandler() {
        if (this.dh == null) {
            this.dh = new MimeBodyPart.MimePartDataHandler(new MimePartDataSource(this));
        }
        return this.dh;
    }

    public Object getContent() {
        Object object;
        if (this.cachedContent != null) {
            return this.cachedContent;
        }
        try {
            object = this.getDataHandler().getContent();
        }
        catch (f f2) {
            throw new FolderClosedException(f2.getFolder(), f2.getMessage());
        }
        catch (i i2) {
            throw new MessageRemovedException(i2.getMessage());
        }
        if (MimeBodyPart.cacheMultipart && (object instanceof Multipart || object instanceof Message) && (this.content != null || this.contentStream != null)) {
            this.cachedContent = object;
            if (object instanceof MimeMultipart) {
                ((MimeMultipart)object).parse();
            }
        }
        return object;
    }

    public synchronized void setDataHandler(DataHandler dataHandler) {
        this.dh = dataHandler;
        this.cachedContent = null;
        MimeBodyPart.invalidateContentHeaders(this);
    }

    public void setContent(Object object, String string) {
        if (object instanceof Multipart) {
            this.setContent((Multipart)object);
        } else {
            this.setDataHandler(new DataHandler(object, string));
        }
    }

    public void setText(String string) {
        this.setText(string, null);
    }

    public void setText(String string, String string2) {
        MimeBodyPart.setText(this, string, string2, "plain");
    }

    public void setText(String string, String string2, String string3) {
        MimeBodyPart.setText(this, string, string2, string3);
    }

    public void setContent(Multipart multipart) {
        this.setDataHandler(new DataHandler((Object)multipart, multipart.getContentType()));
        multipart.setParent(this);
    }

    public Message reply(boolean bl) {
        Object object;
        Object object2;
        MimeMessage mimeMessage = this.createMimeMessage(this.session);
        String string = this.getHeader("Subject", null);
        if (string != null) {
            if (!string.regionMatches(true, 0, "Re: ", 0, 4)) {
                string = "Re: " + string;
            }
            mimeMessage.setHeader("Subject", string);
        }
        Address[] addressArray = this.getReplyTo();
        mimeMessage.setRecipients(Message.RecipientType.TO, addressArray);
        if (bl) {
            object2 = new Vector();
            object = InternetAddress.getLocalAddress(this.session);
            if (object != null) {
                ((Vector)object2).addElement(object);
            }
            String string2 = null;
            if (this.session != null) {
                string2 = this.session.getProperty("mail.alternates");
            }
            if (string2 != null) {
                this.eliminateDuplicates((Vector)object2, InternetAddress.parse(string2, false));
            }
            Object var8_9 = null;
            boolean bl2 = false;
            if (this.session != null) {
                bl2 = l.getBooleanSessionProperty(this.session, "mail.replyallcc", false);
            }
            this.eliminateDuplicates((Vector)object2, addressArray);
            addressArray = this.getRecipients(Message.RecipientType.TO);
            addressArray = this.eliminateDuplicates((Vector)object2, addressArray);
            if (addressArray != null && addressArray.length > 0) {
                if (bl2) {
                    mimeMessage.addRecipients(Message.RecipientType.CC, addressArray);
                } else {
                    mimeMessage.addRecipients(Message.RecipientType.TO, addressArray);
                }
            }
            addressArray = this.getRecipients(Message.RecipientType.CC);
            if ((addressArray = this.eliminateDuplicates((Vector)object2, addressArray)) != null && addressArray.length > 0) {
                mimeMessage.addRecipients(Message.RecipientType.CC, addressArray);
            }
            if ((addressArray = this.getRecipients(RecipientType.NEWSGROUPS)) != null && addressArray.length > 0) {
                mimeMessage.setRecipients((Message.RecipientType)RecipientType.NEWSGROUPS, addressArray);
            }
        }
        if ((object2 = this.getHeader("Message-Id", null)) != null) {
            mimeMessage.setHeader("In-Reply-To", (String)object2);
        }
        if ((object = this.getHeader("References", " ")) == null) {
            object = this.getHeader("In-Reply-To", " ");
        }
        if (object2 != null) {
            object = object != null ? MimeUtility.unfold((String)object) + " " + (String)object2 : object2;
        }
        if (object != null) {
            mimeMessage.setHeader("References", MimeUtility.fold(12, (String)object));
        }
        try {
            this.setFlags(answeredFlag, true);
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        return mimeMessage;
    }

    private Address[] eliminateDuplicates(Vector vector, Address[] addressArray) {
        int n2;
        int n3;
        if (addressArray == null) {
            return null;
        }
        int n4 = 0;
        for (int i2 = 0; i2 < addressArray.length; ++i2) {
            n3 = 0;
            for (n2 = 0; n2 < vector.size(); ++n2) {
                if (!((InternetAddress)vector.elementAt(n2)).equals(addressArray[i2])) continue;
                n3 = 1;
                ++n4;
                addressArray[i2] = null;
                break;
            }
            if (n3 != 0) continue;
            vector.addElement(addressArray[i2]);
        }
        if (n4 != 0) {
            Address[] addressArray2 = addressArray instanceof InternetAddress[] ? new InternetAddress[addressArray.length - n4] : new Address[addressArray.length - n4];
            n2 = 0;
            for (n3 = 0; n3 < addressArray.length; ++n3) {
                if (addressArray[n3] == null) continue;
                addressArray2[n2++] = addressArray[n3];
            }
            addressArray = addressArray2;
        }
        return addressArray;
    }

    public void writeTo(OutputStream outputStream) {
        this.writeTo(outputStream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream outputStream, String[] stringArray) {
        block9: {
            if (!this.saved) {
                this.saveChanges();
            }
            if (this.modified) {
                MimeBodyPart.writeTo(this, outputStream, stringArray);
                return;
            }
            Enumeration enumeration = this.getNonMatchingHeaderLines(stringArray);
            h h2 = new h(outputStream);
            while (enumeration.hasMoreElements()) {
                h2.writeln((String)enumeration.nextElement());
            }
            h2.writeln();
            if (this.content == null) {
                byte[] byArray;
                block8: {
                    InputStream inputStream = null;
                    byArray = new byte[8192];
                    try {
                        int n2;
                        inputStream = this.getContentStream();
                        while ((n2 = inputStream.read(byArray)) > 0) {
                            outputStream.write(byArray, 0, n2);
                        }
                        Object var9_8 = null;
                        if (inputStream == null) break block8;
                    }
                    catch (Throwable throwable) {
                        Object var9_9 = null;
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        byArray = null;
                        throw throwable;
                    }
                    inputStream.close();
                }
                byArray = null;
                {
                    break block9;
                }
            }
            outputStream.write(this.content);
        }
        outputStream.flush();
    }

    public String[] getHeader(String string) {
        return this.headers.getHeader(string);
    }

    public String getHeader(String string, String string2) {
        return this.headers.getHeader(string, string2);
    }

    public void setHeader(String string, String string2) {
        this.headers.setHeader(string, string2);
    }

    public void addHeader(String string, String string2) {
        this.headers.addHeader(string, string2);
    }

    public void removeHeader(String string) {
        this.headers.removeHeader(string);
    }

    public Enumeration getAllHeaders() {
        return this.headers.getAllHeaders();
    }

    public Enumeration getMatchingHeaders(String[] stringArray) {
        return this.headers.getMatchingHeaders(stringArray);
    }

    public Enumeration getNonMatchingHeaders(String[] stringArray) {
        return this.headers.getNonMatchingHeaders(stringArray);
    }

    public void addHeaderLine(String string) {
        this.headers.addHeaderLine(string);
    }

    public Enumeration getAllHeaderLines() {
        return this.headers.getAllHeaderLines();
    }

    public Enumeration getMatchingHeaderLines(String[] stringArray) {
        return this.headers.getMatchingHeaderLines(stringArray);
    }

    public Enumeration getNonMatchingHeaderLines(String[] stringArray) {
        return this.headers.getNonMatchingHeaderLines(stringArray);
    }

    public synchronized Flags getFlags() {
        return (Flags)this.flags.clone();
    }

    public synchronized boolean isSet(Flags.Flag flag) {
        return this.flags.contains(flag);
    }

    public synchronized void setFlags(Flags flags, boolean bl) {
        if (bl) {
            this.flags.add(flags);
        } else {
            this.flags.remove(flags);
        }
    }

    public void saveChanges() {
        this.modified = true;
        this.saved = true;
        this.updateHeaders();
    }

    protected void updateMessageID() {
        this.setHeader("Message-ID", "<" + UniqueValue.getUniqueMessageIDValue(this.session) + ">");
    }

    protected synchronized void updateHeaders() {
        MimeBodyPart.updateHeaders(this);
        this.setHeader("MIME-Version", "1.0");
        this.updateMessageID();
        if (this.cachedContent != null) {
            this.dh = new DataHandler(this.cachedContent, this.getContentType());
            this.cachedContent = null;
            this.content = null;
            if (this.contentStream != null) {
                try {
                    this.contentStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.contentStream = null;
        }
    }

    protected InternetHeaders createInternetHeaders(InputStream inputStream) {
        return new InternetHeaders(inputStream);
    }

    protected MimeMessage createMimeMessage(Session session) {
        return new MimeMessage(session);
    }

    public static class RecipientType
    extends Message.RecipientType {
        private static final long serialVersionUID = -5468290701714395543L;
        public static final RecipientType NEWSGROUPS = new RecipientType("Newsgroups");

        protected RecipientType(String string) {
            super(string);
        }

        protected Object readResolve() {
            if (this.type.equals("Newsgroups")) {
                return NEWSGROUPS;
            }
            return super.readResolve();
        }
    }
}

