/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import com.b.b.a.a;
import com.b.b.a.f;
import com.b.b.a.h;
import com.b.b.a.i;
import com.b.b.a.j;
import com.b.b.a.l;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.BodyPart;
import javax.mail.FolderClosedException;
import javax.mail.Message;
import javax.mail.MessageRemovedException;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.ContentDisposition;
import javax.mail.internet.ContentType;
import javax.mail.internet.HeaderTokenizer;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimePartDataSource;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;
import javax.mail.internet.SharedInputStream;

public class MimeBodyPart
extends BodyPart
implements MimePart {
    private static final boolean setDefaultTextCharset = l.getBooleanSystemProperty("mail.mime.setdefaulttextcharset", true);
    private static final boolean setContentTypeFileName = l.getBooleanSystemProperty("mail.mime.setcontenttypefilename", true);
    private static final boolean encodeFileName = l.getBooleanSystemProperty("mail.mime.encodefilename", false);
    private static final boolean decodeFileName = l.getBooleanSystemProperty("mail.mime.decodefilename", false);
    private static final boolean ignoreMultipartEncoding = l.getBooleanSystemProperty("mail.mime.ignoremultipartencoding", true);
    static final boolean cacheMultipart = l.getBooleanSystemProperty("mail.mime.cachemultipart", true);
    protected DataHandler dh;
    protected byte[] content;
    protected InputStream contentStream;
    protected InternetHeaders headers;
    private Object cachedContent;

    public MimeBodyPart() {
        this.headers = new InternetHeaders();
    }

    public MimeBodyPart(InputStream inputStream) {
        if (!(inputStream instanceof ByteArrayInputStream || inputStream instanceof BufferedInputStream || inputStream instanceof SharedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        this.headers = new InternetHeaders(inputStream);
        if (inputStream instanceof SharedInputStream) {
            SharedInputStream sharedInputStream = (SharedInputStream)((Object)inputStream);
            this.contentStream = sharedInputStream.newStream(sharedInputStream.getPosition(), -1L);
        } else {
            try {
                this.content = a.getBytes(inputStream);
            }
            catch (IOException iOException) {
                throw new MessagingException("Error reading input stream", iOException);
            }
        }
    }

    public MimeBodyPart(InternetHeaders internetHeaders, byte[] byArray) {
        this.headers = internetHeaders;
        this.content = byArray;
    }

    public int getSize() {
        if (this.content != null) {
            return this.content.length;
        }
        if (this.contentStream != null) {
            try {
                int n2 = this.contentStream.available();
                if (n2 > 0) {
                    return n2;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return -1;
    }

    public int getLineCount() {
        return -1;
    }

    public String getContentType() {
        String string = this.getHeader("Content-Type", null);
        if ((string = j.cleanContentType(this, string)) == null) {
            string = "text/plain";
        }
        return string;
    }

    public boolean isMimeType(String string) {
        return MimeBodyPart.isMimeType(this, string);
    }

    public String getDisposition() {
        return MimeBodyPart.getDisposition(this);
    }

    public void setDisposition(String string) {
        MimeBodyPart.setDisposition(this, string);
    }

    public String getEncoding() {
        return MimeBodyPart.getEncoding(this);
    }

    public String getContentID() {
        return this.getHeader("Content-Id", null);
    }

    public void setContentID(String string) {
        if (string == null) {
            this.removeHeader("Content-ID");
        } else {
            this.setHeader("Content-ID", string);
        }
    }

    public String getContentMD5() {
        return this.getHeader("Content-MD5", null);
    }

    public void setContentMD5(String string) {
        this.setHeader("Content-MD5", string);
    }

    public String[] getContentLanguage() {
        return MimeBodyPart.getContentLanguage(this);
    }

    public void setContentLanguage(String[] stringArray) {
        MimeBodyPart.setContentLanguage(this, stringArray);
    }

    public String getDescription() {
        return MimeBodyPart.getDescription(this);
    }

    public void setDescription(String string) {
        this.setDescription(string, null);
    }

    public void setDescription(String string, String string2) {
        MimeBodyPart.setDescription(this, string, string2);
    }

    public String getFileName() {
        return MimeBodyPart.getFileName(this);
    }

    public void setFileName(String string) {
        MimeBodyPart.setFileName(this, string);
    }

    public InputStream getInputStream() {
        return this.getDataHandler().getInputStream();
    }

    protected InputStream getContentStream() {
        if (this.contentStream != null) {
            return ((SharedInputStream)((Object)this.contentStream)).newStream(0L, -1L);
        }
        if (this.content != null) {
            return new ByteArrayInputStream(this.content);
        }
        throw new MessagingException("No MimeBodyPart content");
    }

    public InputStream getRawInputStream() {
        return this.getContentStream();
    }

    public DataHandler getDataHandler() {
        if (this.dh == null) {
            this.dh = new MimePartDataHandler(new MimePartDataSource(this));
        }
        return this.dh;
    }

    public Object getContent() {
        Object object;
        if (this.cachedContent != null) {
            return this.cachedContent;
        }
        try {
            object = this.getDataHandler().getContent();
        }
        catch (f f2) {
            throw new FolderClosedException(f2.getFolder(), f2.getMessage());
        }
        catch (i i2) {
            throw new MessageRemovedException(i2.getMessage());
        }
        if (cacheMultipart && (object instanceof Multipart || object instanceof Message) && (this.content != null || this.contentStream != null)) {
            this.cachedContent = object;
            if (object instanceof MimeMultipart) {
                ((MimeMultipart)object).parse();
            }
        }
        return object;
    }

    public void setDataHandler(DataHandler dataHandler) {
        this.dh = dataHandler;
        this.cachedContent = null;
        MimeBodyPart.invalidateContentHeaders(this);
    }

    public void setContent(Object object, String string) {
        if (object instanceof Multipart) {
            this.setContent((Multipart)object);
        } else {
            this.setDataHandler(new DataHandler(object, string));
        }
    }

    public void setText(String string) {
        this.setText(string, null);
    }

    public void setText(String string, String string2) {
        MimeBodyPart.setText(this, string, string2, "plain");
    }

    public void setText(String string, String string2, String string3) {
        MimeBodyPart.setText(this, string, string2, string3);
    }

    public void setContent(Multipart multipart) {
        this.setDataHandler(new DataHandler((Object)multipart, multipart.getContentType()));
        multipart.setParent(this);
    }

    public void attachFile(File file) {
        FileDataSource fileDataSource = new FileDataSource(file);
        this.setDataHandler(new DataHandler((DataSource)fileDataSource));
        this.setFileName(fileDataSource.getName());
    }

    public void attachFile(String string) {
        File file = new File(string);
        this.attachFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFile(File file) {
        BufferedOutputStream bufferedOutputStream = null;
        InputStream inputStream = null;
        try {
            int n2;
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            inputStream = this.getInputStream();
            byte[] byArray = new byte[8192];
            while ((n2 = inputStream.read(byArray)) > 0) {
                ((OutputStream)bufferedOutputStream).write(byArray, 0, n2);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (bufferedOutputStream != null) {
                    ((OutputStream)bufferedOutputStream).close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (bufferedOutputStream != null) {
                ((OutputStream)bufferedOutputStream).close();
            }
        }
        catch (IOException iOException) {}
    }

    public void saveFile(String string) {
        File file = new File(string);
        this.saveFile(file);
    }

    public void writeTo(OutputStream outputStream) {
        MimeBodyPart.writeTo(this, outputStream, null);
    }

    public String[] getHeader(String string) {
        return this.headers.getHeader(string);
    }

    public String getHeader(String string, String string2) {
        return this.headers.getHeader(string, string2);
    }

    public void setHeader(String string, String string2) {
        this.headers.setHeader(string, string2);
    }

    public void addHeader(String string, String string2) {
        this.headers.addHeader(string, string2);
    }

    public void removeHeader(String string) {
        this.headers.removeHeader(string);
    }

    public Enumeration getAllHeaders() {
        return this.headers.getAllHeaders();
    }

    public Enumeration getMatchingHeaders(String[] stringArray) {
        return this.headers.getMatchingHeaders(stringArray);
    }

    public Enumeration getNonMatchingHeaders(String[] stringArray) {
        return this.headers.getNonMatchingHeaders(stringArray);
    }

    public void addHeaderLine(String string) {
        this.headers.addHeaderLine(string);
    }

    public Enumeration getAllHeaderLines() {
        return this.headers.getAllHeaderLines();
    }

    public Enumeration getMatchingHeaderLines(String[] stringArray) {
        return this.headers.getMatchingHeaderLines(stringArray);
    }

    public Enumeration getNonMatchingHeaderLines(String[] stringArray) {
        return this.headers.getNonMatchingHeaderLines(stringArray);
    }

    protected void updateHeaders() {
        MimeBodyPart.updateHeaders(this);
        if (this.cachedContent != null) {
            this.dh = new DataHandler(this.cachedContent, this.getContentType());
            this.cachedContent = null;
            this.content = null;
            if (this.contentStream != null) {
                try {
                    this.contentStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.contentStream = null;
        }
    }

    static boolean isMimeType(MimePart mimePart, String string) {
        try {
            ContentType contentType = new ContentType(mimePart.getContentType());
            return contentType.match(string);
        }
        catch (ParseException parseException) {
            return mimePart.getContentType().equalsIgnoreCase(string);
        }
    }

    static void setText(MimePart mimePart, String string, String string2, String string3) {
        if (string2 == null) {
            string2 = MimeUtility.checkAscii(string) != 1 ? MimeUtility.getDefaultMIMECharset() : "us-ascii";
        }
        mimePart.setContent(string, "text/" + string3 + "; charset=" + MimeUtility.quote(string2, "()<>@,;:\\\"\t []/?="));
    }

    static String getDisposition(MimePart mimePart) {
        String string = mimePart.getHeader("Content-Disposition", null);
        if (string == null) {
            return null;
        }
        ContentDisposition contentDisposition = new ContentDisposition(string);
        return contentDisposition.getDisposition();
    }

    static void setDisposition(MimePart mimePart, String string) {
        if (string == null) {
            mimePart.removeHeader("Content-Disposition");
        } else {
            String string2 = mimePart.getHeader("Content-Disposition", null);
            if (string2 != null) {
                ContentDisposition contentDisposition = new ContentDisposition(string2);
                contentDisposition.setDisposition(string);
                string = contentDisposition.toString();
            }
            mimePart.setHeader("Content-Disposition", string);
        }
    }

    static String getDescription(MimePart mimePart) {
        String string = mimePart.getHeader("Content-Description", null);
        if (string == null) {
            return null;
        }
        try {
            return MimeUtility.decodeText(MimeUtility.unfold(string));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    static void setDescription(MimePart mimePart, String string, String string2) {
        if (string == null) {
            mimePart.removeHeader("Content-Description");
            return;
        }
        try {
            mimePart.setHeader("Content-Description", MimeUtility.fold(21, MimeUtility.encodeText(string, string2, null)));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new MessagingException("Encoding error", unsupportedEncodingException);
        }
    }

    static String getFileName(MimePart mimePart) {
        Object object;
        String string = null;
        String string2 = mimePart.getHeader("Content-Disposition", null);
        if (string2 != null) {
            object = new ContentDisposition(string2);
            string = ((ContentDisposition)object).getParameter("filename");
        }
        if (string == null) {
            string2 = mimePart.getHeader("Content-Type", null);
            if ((string2 = j.cleanContentType(mimePart, string2)) != null) {
                try {
                    object = new ContentType(string2);
                    string = ((ContentType)object).getParameter("name");
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        if (decodeFileName && string != null) {
            try {
                string = MimeUtility.decodeText(string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new MessagingException("Can't decode filename", unsupportedEncodingException);
            }
        }
        return string;
    }

    static void setFileName(MimePart mimePart, String string) {
        String string2;
        if (encodeFileName && string != null) {
            try {
                string = MimeUtility.encodeText(string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new MessagingException("Can't encode filename", unsupportedEncodingException);
            }
        }
        ContentDisposition contentDisposition = new ContentDisposition((string2 = mimePart.getHeader("Content-Disposition", null)) == null ? "attachment" : string2);
        contentDisposition.setParameter("filename", string);
        mimePart.setHeader("Content-Disposition", contentDisposition.toString());
        if (setContentTypeFileName) {
            string2 = mimePart.getHeader("Content-Type", null);
            if ((string2 = j.cleanContentType(mimePart, string2)) != null) {
                try {
                    ContentType contentType = new ContentType(string2);
                    contentType.setParameter("name", string);
                    mimePart.setHeader("Content-Type", contentType.toString());
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
    }

    static String[] getContentLanguage(MimePart mimePart) {
        HeaderTokenizer.Token token;
        int n2;
        String string = mimePart.getHeader("Content-Language", null);
        if (string == null) {
            return null;
        }
        HeaderTokenizer headerTokenizer = new HeaderTokenizer(string, "()<>@,;:\\\"\t []/?=");
        Vector<String> vector = new Vector<String>();
        while ((n2 = (token = headerTokenizer.next()).getType()) != -4) {
            if (n2 != -1) continue;
            vector.addElement(token.getValue());
        }
        if (vector.size() == 0) {
            return null;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    static void setContentLanguage(MimePart mimePart, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
        int n2 = "Content-Language".length() + 2 + stringArray[0].length();
        for (int i2 = 1; i2 < stringArray.length; ++i2) {
            stringBuffer.append(',');
            if (++n2 > 76) {
                stringBuffer.append("\r\n\t");
                n2 = 8;
            }
            stringBuffer.append(stringArray[i2]);
            n2 += stringArray[i2].length();
        }
        mimePart.setHeader("Content-Language", stringBuffer.toString());
    }

    static String getEncoding(MimePart mimePart) {
        HeaderTokenizer.Token token;
        int n2;
        String string = mimePart.getHeader("Content-Transfer-Encoding", null);
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).equalsIgnoreCase("7bit") || string.equalsIgnoreCase("8bit") || string.equalsIgnoreCase("quoted-printable") || string.equalsIgnoreCase("binary") || string.equalsIgnoreCase("base64")) {
            return string;
        }
        HeaderTokenizer headerTokenizer = new HeaderTokenizer(string, "()<>@,;:\\\"\t []/?=");
        while ((n2 = (token = headerTokenizer.next()).getType()) != -4) {
            if (n2 != -1) continue;
            return token.getValue();
        }
        return string;
    }

    static void setEncoding(MimePart mimePart, String string) {
        mimePart.setHeader("Content-Transfer-Encoding", string);
    }

    static String restrictEncoding(MimePart mimePart, String string) {
        if (!ignoreMultipartEncoding || string == null) {
            return string;
        }
        if (string.equalsIgnoreCase("7bit") || string.equalsIgnoreCase("8bit") || string.equalsIgnoreCase("binary")) {
            return string;
        }
        String string2 = mimePart.getContentType();
        if (string2 == null) {
            return string;
        }
        try {
            ContentType contentType = new ContentType(string2);
            if (contentType.match("multipart/*")) {
                return null;
            }
            if (contentType.match("message/*") && !l.getBooleanSystemProperty("mail.mime.allowencodedmessages", false)) {
                return null;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void updateHeaders(MimePart mimePart) {
        DataHandler dataHandler = mimePart.getDataHandler();
        if (dataHandler == null) {
            return;
        }
        try {
            String string;
            Object object;
            Object object2;
            String string2 = dataHandler.getContentType();
            boolean bl = false;
            boolean bl2 = mimePart.getHeader("Content-Type") == null;
            ContentType contentType = new ContentType(string2);
            if (contentType.match("multipart/*")) {
                bl = true;
                if (mimePart instanceof MimeBodyPart) {
                    object2 = (MimeBodyPart)mimePart;
                    object = ((MimeBodyPart)object2).cachedContent != null ? ((MimeBodyPart)object2).cachedContent : dataHandler.getContent();
                } else if (mimePart instanceof MimeMessage) {
                    object2 = (MimeMessage)mimePart;
                    object = ((MimeMessage)object2).cachedContent != null ? ((MimeMessage)object2).cachedContent : dataHandler.getContent();
                } else {
                    object = dataHandler.getContent();
                }
                if (!(object instanceof MimeMultipart)) throw new MessagingException("MIME part of type \"" + string2 + "\" contains object of type " + object.getClass().getName() + " instead of MimeMultipart");
                ((MimeMultipart)object).updateHeaders();
            } else if (contentType.match("message/rfc822")) {
                bl = true;
            }
            if (dataHandler instanceof MimePartDataHandler) {
                return;
            }
            if (!bl) {
                if (mimePart.getHeader("Content-Transfer-Encoding") == null) {
                    MimeBodyPart.setEncoding(mimePart, MimeUtility.getEncoding(dataHandler));
                }
                if (bl2 && setDefaultTextCharset && contentType.match("text/*") && contentType.getParameter("charset") == null) {
                    object2 = mimePart.getEncoding();
                    object = object2 != null && ((String)object2).equalsIgnoreCase("7bit") ? "us-ascii" : MimeUtility.getDefaultMIMECharset();
                    contentType.setParameter("charset", (String)object);
                    string2 = contentType.toString();
                }
            }
            if (!bl2) return;
            object = mimePart.getHeader("Content-Disposition", null);
            if (object != null && (string = ((ContentDisposition)(object2 = new ContentDisposition((String)object))).getParameter("filename")) != null) {
                contentType.setParameter("name", string);
                string2 = contentType.toString();
            }
            mimePart.setHeader("Content-Type", string2);
            return;
        }
        catch (IOException iOException) {
            throw new MessagingException("IOException updating headers", iOException);
        }
    }

    static void invalidateContentHeaders(MimePart mimePart) {
        mimePart.removeHeader("Content-Type");
        mimePart.removeHeader("Content-Transfer-Encoding");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void writeTo(MimePart mimePart, OutputStream outputStream, String[] stringArray) {
        byte[] byArray;
        block11: {
            h h2 = null;
            h2 = outputStream instanceof h ? (h)outputStream : new h(outputStream);
            Enumeration enumeration = mimePart.getNonMatchingHeaderLines(stringArray);
            while (enumeration.hasMoreElements()) {
                h2.writeln((String)enumeration.nextElement());
            }
            h2.writeln();
            InputStream inputStream = null;
            byArray = null;
            try {
                DataHandler dataHandler = mimePart.getDataHandler();
                if (dataHandler instanceof MimePartDataHandler) {
                    MimePart mimePart2;
                    if (mimePart instanceof MimeBodyPart) {
                        mimePart2 = (MimeBodyPart)mimePart;
                        inputStream = ((MimeBodyPart)mimePart2).getContentStream();
                    } else if (mimePart instanceof MimeMessage) {
                        mimePart2 = (MimeMessage)mimePart;
                        inputStream = ((MimeMessage)mimePart2).getContentStream();
                    }
                }
                if (inputStream != null) {
                    int n2;
                    byArray = new byte[8192];
                    while ((n2 = inputStream.read(byArray)) > 0) {
                        outputStream.write(byArray, 0, n2);
                    }
                } else {
                    outputStream = MimeUtility.encode(outputStream, MimeBodyPart.restrictEncoding(mimePart, mimePart.getEncoding()));
                    mimePart.getDataHandler().writeTo(outputStream);
                }
                Object var10_10 = null;
                if (inputStream == null) break block11;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                if (inputStream != null) {
                    inputStream.close();
                }
                byArray = null;
                throw throwable;
            }
            inputStream.close();
        }
        byArray = null;
        outputStream.flush();
    }

    static class MimePartDataHandler
    extends DataHandler {
        public MimePartDataHandler(DataSource dataSource) {
            super(dataSource);
        }
    }
}

