/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import com.b.b.a.l;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.mail.Address;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.MimeUtility;

public class InternetAddress
extends Address
implements Cloneable {
    protected String address;
    protected String personal;
    protected String encodedPersonal;
    private static final long serialVersionUID = -7507595530758302903L;
    private static final boolean ignoreBogusGroupName = l.getBooleanSystemProperty("mail.mime.address.ignorebogusgroupname", true);
    private static final String rfc822phrase = "()<>@,;:\\\"\t .[]".replace(' ', '\u0000').replace('\t', '\u0000');
    private static final String specialsNoDotNoAt = "()<>,;:\\\"[]";
    private static final String specialsNoDot = "()<>,;:\\\"[]@";

    public InternetAddress() {
    }

    public InternetAddress(String string) {
        InternetAddress[] internetAddressArray = InternetAddress.parse(string, true);
        if (internetAddressArray.length != 1) {
            throw new AddressException("Illegal address", string);
        }
        this.address = internetAddressArray[0].address;
        this.personal = internetAddressArray[0].personal;
        this.encodedPersonal = internetAddressArray[0].encodedPersonal;
    }

    public InternetAddress(String string, boolean bl) {
        this(string);
        if (bl) {
            if (this.isGroup()) {
                this.getGroup(true);
            } else {
                InternetAddress.checkAddress(this.address, true, true);
            }
        }
    }

    public InternetAddress(String string, String string2) {
        this(string, string2, null);
    }

    public InternetAddress(String string, String string2, String string3) {
        this.address = string;
        this.setPersonal(string2, string3);
    }

    public Object clone() {
        InternetAddress internetAddress = null;
        try {
            internetAddress = (InternetAddress)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return internetAddress;
    }

    public String getType() {
        return "rfc822";
    }

    public void setAddress(String string) {
        this.address = string;
    }

    public void setPersonal(String string, String string2) {
        this.personal = string;
        this.encodedPersonal = string != null ? MimeUtility.encodeWord(string, string2, null) : null;
    }

    public void setPersonal(String string) {
        this.personal = string;
        this.encodedPersonal = string != null ? MimeUtility.encodeWord(string) : null;
    }

    public String getAddress() {
        return this.address;
    }

    public String getPersonal() {
        if (this.personal != null) {
            return this.personal;
        }
        if (this.encodedPersonal != null) {
            try {
                this.personal = MimeUtility.decodeText(this.encodedPersonal);
                return this.personal;
            }
            catch (Exception exception) {
                return this.encodedPersonal;
            }
        }
        return null;
    }

    public String toString() {
        if (this.encodedPersonal == null && this.personal != null) {
            try {
                this.encodedPersonal = MimeUtility.encodeWord(this.personal);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (this.encodedPersonal != null) {
            return InternetAddress.quotePhrase(this.encodedPersonal) + " <" + this.address + ">";
        }
        if (this.isGroup() || this.isSimple()) {
            return this.address;
        }
        return "<" + this.address + ">";
    }

    public String toUnicodeString() {
        String string = this.getPersonal();
        if (string != null) {
            return InternetAddress.quotePhrase(string) + " <" + this.address + ">";
        }
        if (this.isGroup() || this.isSimple()) {
            return this.address;
        }
        return "<" + this.address + ">";
    }

    private static String quotePhrase(String string) {
        int n2 = string.length();
        boolean bl = false;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '\"' || c2 == '\\') {
                StringBuffer stringBuffer = new StringBuffer(n2 + 3);
                stringBuffer.append('\"');
                for (int i3 = 0; i3 < n2; ++i3) {
                    char c3 = string.charAt(i3);
                    if (c3 == '\"' || c3 == '\\') {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(c3);
                }
                stringBuffer.append('\"');
                return stringBuffer.toString();
            }
            if ((c2 >= ' ' || c2 == '\r' || c2 == '\n' || c2 == '\t') && c2 < '\u007f' && rfc822phrase.indexOf(c2) < 0) continue;
            bl = true;
        }
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer(n2 + 2);
            stringBuffer.append('\"').append(string).append('\"');
            return stringBuffer.toString();
        }
        return string;
    }

    private static String unquote(String string) {
        if (string.startsWith("\"") && string.endsWith("\"") && (string = string.substring(1, string.length() - 1)).indexOf(92) >= 0) {
            StringBuffer stringBuffer = new StringBuffer(string.length());
            for (int i2 = 0; i2 < string.length(); ++i2) {
                char c2 = string.charAt(i2);
                if (c2 == '\\' && i2 < string.length() - 1) {
                    c2 = string.charAt(++i2);
                }
                stringBuffer.append(c2);
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public boolean equals(Object object) {
        if (!(object instanceof InternetAddress)) {
            return false;
        }
        String string = ((InternetAddress)object).getAddress();
        if (string == this.address) {
            return true;
        }
        return this.address != null && this.address.equalsIgnoreCase(string);
    }

    public int hashCode() {
        if (this.address == null) {
            return 0;
        }
        return this.address.toLowerCase(Locale.ENGLISH).hashCode();
    }

    public static String toString(Address[] addressArray) {
        return InternetAddress.toString(addressArray, 0);
    }

    public static String toString(Address[] addressArray, int n2) {
        if (addressArray == null || addressArray.length == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < addressArray.length; ++i2) {
            String string;
            int n3;
            if (i2 != 0) {
                stringBuffer.append(", ");
                n2 += 2;
            }
            if (n2 + (n3 = InternetAddress.lengthOfFirstSegment(string = addressArray[i2].toString())) > 76) {
                stringBuffer.append("\r\n\t");
                n2 = 8;
            }
            stringBuffer.append(string);
            n2 = InternetAddress.lengthOfLastSegment(string, n2);
        }
        return stringBuffer.toString();
    }

    private static int lengthOfFirstSegment(String string) {
        int n2 = string.indexOf("\r\n");
        if (n2 != -1) {
            return n2;
        }
        return string.length();
    }

    private static int lengthOfLastSegment(String string, int n2) {
        int n3 = string.lastIndexOf("\r\n");
        if (n3 != -1) {
            return string.length() - n3 - 2;
        }
        return string.length() + n2;
    }

    public static InternetAddress getLocalAddress(Session session) {
        try {
            return InternetAddress._getLocalAddress(session);
        }
        catch (SecurityException securityException) {
        }
        catch (AddressException addressException) {
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return null;
    }

    static InternetAddress _getLocalAddress(Session session) {
        String string = null;
        String string2 = null;
        String string3 = null;
        if (session == null) {
            string = System.getProperty("user.name");
            string2 = InternetAddress.getLocalHostName();
        } else {
            string3 = session.getProperty("mail.from");
            if (string3 == null) {
                string = session.getProperty("mail.user");
                if (string == null || string.length() == 0) {
                    string = session.getProperty("user.name");
                }
                if (string == null || string.length() == 0) {
                    string = System.getProperty("user.name");
                }
                if ((string2 = session.getProperty("mail.host")) == null || string2.length() == 0) {
                    string2 = InternetAddress.getLocalHostName();
                }
            }
        }
        if (string3 == null && string != null && string.length() != 0 && string2 != null && string2.length() != 0) {
            string3 = MimeUtility.quote(string.trim(), "()<>,;:\\\"[]@\t ") + "@" + string2;
        }
        if (string3 == null) {
            return null;
        }
        return new InternetAddress(string3);
    }

    private static String getLocalHostName() {
        String string = null;
        InetAddress inetAddress = InetAddress.getLocalHost();
        if (inetAddress != null && (string = inetAddress.getHostName()) != null && string.length() > 0 && InternetAddress.isInetAddressLiteral(string)) {
            string = '[' + string + ']';
        }
        return string;
    }

    private static boolean isInetAddressLiteral(String string) {
        boolean bl = false;
        boolean bl2 = false;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= '0' && c2 <= '9' || c2 == '.') continue;
            if (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z') {
                bl = true;
                continue;
            }
            if (c2 == ':') {
                bl2 = true;
                continue;
            }
            return false;
        }
        return !bl || bl2;
    }

    public static InternetAddress[] parse(String string) {
        return InternetAddress.parse(string, true);
    }

    public static InternetAddress[] parse(String string, boolean bl) {
        return InternetAddress.parse(string, bl, false);
    }

    public static InternetAddress[] parseHeader(String string, boolean bl) {
        return InternetAddress.parse(string, bl, true);
    }

    /*
     * Unable to fully structure code
     */
    private static InternetAddress[] parse(String var0, boolean var1_1, boolean var2_2) {
        var7_3 = -1;
        var8_4 = -1;
        var9_5 = var0.length();
        var10_6 = var2_2 != false && var1_1 == false;
        var11_7 = false;
        var12_8 = false;
        var13_9 = false;
        var15_10 = new ArrayList<InternetAddress>();
        var4_11 = -1;
        var3_12 = -1;
        block30: for (var5_13 = 0; var5_13 < var9_5; ++var5_13) {
            var14_15 = var0.charAt(var5_13);
            switch (var14_15) {
                case '(': {
                    var13_9 = true;
                    if (var3_12 >= 0 && var4_11 == -1) {
                        var4_11 = var5_13;
                    }
                    var17_17 = var5_13++;
                    var6_14 = 1;
                    while (var5_13 < var9_5 && var6_14 > 0) {
                        var14_15 = var0.charAt(var5_13);
                        switch (var14_15) {
                            case '\\': {
                                ++var5_13;
                                break;
                            }
                            case '(': {
                                ++var6_14;
                                break;
                            }
                            case ')': {
                                --var6_14;
                                break;
                            }
                        }
                        ++var5_13;
                    }
                    if (var6_14 > 0) {
                        if (!var10_6) {
                            throw new AddressException("Missing ')'", var0, var5_13);
                        }
                        var5_13 = var17_17 + 1;
                        continue block30;
                    }
                    --var5_13;
                    if (var7_3 == -1) {
                        var7_3 = var17_17 + 1;
                    }
                    if (var8_4 != -1) continue block30;
                    var8_4 = var5_13;
                    continue block30;
                }
                case ')': {
                    if (!var10_6) {
                        throw new AddressException("Missing '('", var0, var5_13);
                    }
                    if (var3_12 != -1) continue block30;
                    var3_12 = var5_13;
                    continue block30;
                }
                case '<': {
                    var13_9 = true;
                    if (var12_8) {
                        if (!var10_6) {
                            throw new AddressException("Extra route-addr", var0, var5_13);
                        }
                        if (var3_12 == -1) {
                            var12_8 = false;
                            var13_9 = false;
                            var4_11 = -1;
                            var3_12 = -1;
                            continue block30;
                        }
                        if (!var11_7) {
                            if (var4_11 == -1) {
                                var4_11 = var5_13;
                            }
                            var18_21 = var0.substring(var3_12, var4_11).trim();
                            var16_16 = new InternetAddress();
                            var16_16.setAddress(var18_21);
                            if (var7_3 >= 0) {
                                var16_16.encodedPersonal = InternetAddress.unquote(var0.substring(var7_3, var8_4).trim());
                            }
                            var15_10.add(var16_16);
                            var12_8 = false;
                            var13_9 = false;
                            var4_11 = -1;
                            var3_12 = -1;
                            var8_4 = -1;
                            var7_3 = -1;
                        }
                    }
                    var18_20 = var5_13++;
                    var19_23 = false;
                    block32: while (var5_13 < var9_5) {
                        var14_15 = var0.charAt(var5_13);
                        switch (var14_15) {
                            case '\\': {
                                ++var5_13;
                                ** GOTO lbl91
                            }
                            case '\"': {
                                var19_23 = var19_23 == false;
                                ** GOTO lbl91
                            }
                            case '>': {
                                if (!var19_23) break block32;
                            }
lbl91:
                            // 4 sources

                            default: {
                                ++var5_13;
                                continue block32;
                            }
                        }
                    }
                    if (var19_23) {
                        if (!var10_6) {
                            throw new AddressException("Missing '\"'", var0, var5_13);
                        }
                        for (var5_13 = var18_20 + 1; var5_13 < var9_5; ++var5_13) {
                            var14_15 = var0.charAt(var5_13);
                            if (var14_15 == '\\') {
                                ++var5_13;
                                continue;
                            }
                            if (var14_15 == '>') break;
                        }
                    }
                    if (var5_13 >= var9_5) {
                        if (!var10_6) {
                            throw new AddressException("Missing '>'", var0, var5_13);
                        }
                        var5_13 = var18_20 + 1;
                        if (var3_12 != -1) continue block30;
                        var3_12 = var18_20;
                        continue block30;
                    }
                    if (!var11_7) {
                        var7_3 = var3_12;
                        if (var7_3 >= 0) {
                            var8_4 = var18_20;
                        }
                        var3_12 = var18_20 + 1;
                    }
                    var12_8 = true;
                    var4_11 = var5_13;
                    continue block30;
                }
                case '>': {
                    if (!var10_6) {
                        throw new AddressException("Missing '<'", var0, var5_13);
                    }
                    if (var3_12 != -1) continue block30;
                    var3_12 = var5_13;
                    continue block30;
                }
                case '\"': {
                    var20_27 = var5_13;
                    var13_9 = true;
                    if (var3_12 == -1) {
                        var3_12 = var5_13;
                    }
                    ++var5_13;
                    block34: while (var5_13 < var9_5) {
                        var14_15 = var0.charAt(var5_13);
                        switch (var14_15) {
                            case '\\': {
                                ++var5_13;
                                ** GOTO lbl139
                            }
                            case '\"': {
                                break block34;
                            }
lbl139:
                            // 2 sources

                            default: {
                                ++var5_13;
                                continue block34;
                            }
                        }
                    }
                    if (var5_13 < var9_5) continue block30;
                    if (!var10_6) {
                        throw new AddressException("Missing '\"'", var0, var5_13);
                    }
                    var5_13 = var20_27 + 1;
                    continue block30;
                }
                case '[': {
                    var13_9 = true;
                    var21_29 = var5_13++;
                    block35: while (var5_13 < var9_5) {
                        var14_15 = var0.charAt(var5_13);
                        switch (var14_15) {
                            case '\\': {
                                ++var5_13;
                                ** GOTO lbl158
                            }
                            case ']': {
                                break block35;
                            }
lbl158:
                            // 2 sources

                            default: {
                                ++var5_13;
                                continue block35;
                            }
                        }
                    }
                    if (var5_13 < var9_5) continue block30;
                    if (!var10_6) {
                        throw new AddressException("Missing ']'", var0, var5_13);
                    }
                    var5_13 = var21_29 + 1;
                    continue block30;
                }
                case ';': {
                    if (var3_12 == -1) {
                        var12_8 = false;
                        var13_9 = false;
                        var4_11 = -1;
                        var3_12 = -1;
                        continue block30;
                    }
                    if (var11_7) {
                        var11_7 = false;
                        if (var2_2 && !var1_1 && var5_13 + 1 < var9_5 && var0.charAt(var5_13 + 1) == '@') continue block30;
                        var16_16 = new InternetAddress();
                        var4_11 = var5_13 + 1;
                        var16_16.setAddress(var0.substring(var3_12, var4_11).trim());
                        var15_10.add(var16_16);
                        var12_8 = false;
                        var13_9 = false;
                        var4_11 = -1;
                        var3_12 = -1;
                        var8_4 = -1;
                        var7_3 = -1;
                        continue block30;
                    }
                    if (!var10_6) {
                        throw new AddressException("Illegal semicolon, not in group", var0, var5_13);
                    }
                }
                case ',': {
                    if (var3_12 == -1) {
                        var12_8 = false;
                        var13_9 = false;
                        var4_11 = -1;
                        var3_12 = -1;
                        continue block30;
                    }
                    if (var11_7) {
                        var12_8 = false;
                        continue block30;
                    }
                    if (var4_11 == -1) {
                        var4_11 = var5_13;
                    }
                    var22_30 = var0.substring(var3_12, var4_11).trim();
                    var23_31 = null;
                    if (var13_9 && var7_3 >= 0 && (var23_31 = InternetAddress.unquote(var0.substring(var7_3, var8_4).trim())).trim().length() == 0) {
                        var23_31 = null;
                    }
                    if (var2_2 && !var1_1 && var23_31 != null && var23_31.indexOf(64) >= 0 && var22_30.indexOf(64) < 0 && var22_30.indexOf(33) < 0) {
                        var24_32 = var22_30;
                        var22_30 = var23_31;
                        var23_31 = var24_32;
                    }
                    if (var13_9 || var1_1 || var2_2) {
                        if (!var10_6) {
                            InternetAddress.checkAddress(var22_30, var12_8, false);
                        }
                        var16_16 = new InternetAddress();
                        var16_16.setAddress(var22_30);
                        if (var23_31 != null) {
                            var16_16.encodedPersonal = var23_31;
                        }
                        var15_10.add(var16_16);
                    } else {
                        var24_32 = new StringTokenizer(var22_30);
                        while (var24_32.hasMoreTokens()) {
                            var25_33 = var24_32.nextToken();
                            InternetAddress.checkAddress(var25_33, false, false);
                            var16_16 = new InternetAddress();
                            var16_16.setAddress(var25_33);
                            var15_10.add(var16_16);
                        }
                    }
                    var12_8 = false;
                    var13_9 = false;
                    var4_11 = -1;
                    var3_12 = -1;
                    var8_4 = -1;
                    var7_3 = -1;
                    continue block30;
                }
                case ':': {
                    var13_9 = true;
                    if (var11_7 && !var10_6) {
                        throw new AddressException("Nested group", var0, var5_13);
                    }
                    if (var3_12 == -1) {
                        var3_12 = var5_13;
                    }
                    if (var2_2 && !var1_1) {
                        if (var5_13 + 1 < var9_5 && (var24_32 = ")>[]:@\\,.").indexOf(var25_34 = var0.charAt(var5_13 + 1)) >= 0) {
                            if (var25_34 != '@') continue block30;
                            for (var26_35 = var5_13 + 2; var26_35 < var9_5 && (var25_34 = var0.charAt(var26_35)) != ';' && var24_32.indexOf(var25_34) < 0; ++var26_35) {
                            }
                            if (var25_34 == ';') continue block30;
                        }
                        var24_32 = var0.substring(var3_12, var5_13);
                        if (InternetAddress.ignoreBogusGroupName && (var24_32.equalsIgnoreCase("mailto") || var24_32.equalsIgnoreCase("From") || var24_32.equalsIgnoreCase("To") || var24_32.equalsIgnoreCase("Cc") || var24_32.equalsIgnoreCase("Subject") || var24_32.equalsIgnoreCase("Re"))) {
                            var3_12 = -1;
                            continue block30;
                        }
                        var11_7 = true;
                        continue block30;
                    }
                    var11_7 = true;
                    continue block30;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block30;
                }
                default: {
                    if (var3_12 != -1) continue block30;
                    var3_12 = var5_13;
                }
            }
        }
        if (var3_12 >= 0) {
            if (var4_11 == -1) {
                var4_11 = var9_5;
            }
            var17_18 = var0.substring(var3_12, var4_11).trim();
            var18_22 = null;
            if (var13_9 && var7_3 >= 0 && (var18_22 = InternetAddress.unquote(var0.substring(var7_3, var8_4).trim())).trim().length() == 0) {
                var18_22 = null;
            }
            if (var2_2 && !var1_1 && var18_22 != null && var18_22.indexOf(64) >= 0 && var17_18.indexOf(64) < 0 && var17_18.indexOf(33) < 0) {
                var19_24 = var17_18;
                var17_18 = var18_22;
                var18_22 = var19_24;
            }
            if (var13_9 || var1_1 || var2_2) {
                if (!var10_6) {
                    InternetAddress.checkAddress(var17_18, var12_8, false);
                }
                var16_16 = new InternetAddress();
                var16_16.setAddress(var17_18);
                if (var18_22 != null) {
                    var16_16.encodedPersonal = var18_22;
                }
                var15_10.add(var16_16);
            } else {
                var19_26 = new StringTokenizer(var17_18);
                while (var19_26.hasMoreTokens()) {
                    var20_28 = var19_26.nextToken();
                    InternetAddress.checkAddress(var20_28, false, false);
                    var16_16 = new InternetAddress();
                    var16_16.setAddress(var20_28);
                    var15_10.add(var16_16);
                }
            }
        }
        var17_19 = new InternetAddress[var15_10.size()];
        var15_10.toArray(var17_19);
        return var17_19;
    }

    public void validate() {
        if (this.isGroup()) {
            this.getGroup(true);
        } else {
            InternetAddress.checkAddress(this.getAddress(), true, true);
        }
    }

    private static void checkAddress(String string, boolean bl, boolean bl2) {
        int n2;
        int n3 = 0;
        int n4 = string.length();
        if (n4 == 0) {
            throw new AddressException("Empty address", string);
        }
        if (bl && string.charAt(0) == '@') {
            n3 = 0;
            while ((n2 = InternetAddress.indexOfAny(string, ",:", n3)) >= 0) {
                if (string.charAt(n3) != '@') {
                    throw new AddressException("Illegal route-addr", string);
                }
                if (string.charAt(n2) == ':') {
                    n3 = n2 + 1;
                    break;
                }
                n3 = n2 + 1;
            }
        }
        char c2 = '\uffff';
        char c3 = '\uffff';
        boolean bl3 = false;
        for (n2 = n3; n2 < n4; ++n2) {
            c3 = c2;
            c2 = string.charAt(n2);
            if (c2 == 92 || c3 == '\\') continue;
            if (c2 == '\"') {
                if (bl3) {
                    if (bl2 && n2 + 1 < n4 && string.charAt(n2 + 1) != '@') {
                        throw new AddressException("Quote not at end of local address", string);
                    }
                    bl3 = false;
                    continue;
                }
                if (bl2 && n2 != 0) {
                    throw new AddressException("Quote not at start of local address", string);
                }
                bl3 = true;
                continue;
            }
            if (bl3) continue;
            if (c2 == '@') {
                if (n2 != 0) break;
                throw new AddressException("Missing local name", string);
            }
            if (c2 <= ' ' || c2 >= '\u007f') {
                throw new AddressException("Local address contains control or whitespace", string);
            }
            if (specialsNoDot.indexOf(c2) < 0) continue;
            throw new AddressException("Local address contains illegal character", string);
        }
        if (bl3) {
            throw new AddressException("Unterminated quote", string);
        }
        if (c2 != '@') {
            if (bl2) {
                throw new AddressException("Missing final '@domain'", string);
            }
            return;
        }
        n3 = n2 + 1;
        if (n3 >= n4) {
            throw new AddressException("Missing domain", string);
        }
        if (string.charAt(n3) == '.') {
            throw new AddressException("Domain starts with dot", string);
        }
        for (n2 = n3; n2 < n4; ++n2) {
            c2 = string.charAt(n2);
            if (c2 == '[') {
                return;
            }
            if (c2 <= ' ' || c2 >= '\u007f') {
                throw new AddressException("Domain contains control or whitespace", string);
            }
            if (!Character.isLetterOrDigit(c2) && c2 != '-' && c2 != '.') {
                throw new AddressException("Domain contains illegal character", string);
            }
            if (c2 == '.' && c3 == '.') {
                throw new AddressException("Domain contains dot-dot", string);
            }
            c3 = c2;
        }
        if (c3 == '.') {
            throw new AddressException("Domain ends with dot", string);
        }
    }

    private boolean isSimple() {
        return this.address == null || InternetAddress.indexOfAny(this.address, specialsNoDotNoAt) < 0;
    }

    public boolean isGroup() {
        return this.address != null && this.address.endsWith(";") && this.address.indexOf(58) > 0;
    }

    public InternetAddress[] getGroup(boolean bl) {
        String string = this.getAddress();
        if (!string.endsWith(";")) {
            return null;
        }
        int n2 = string.indexOf(58);
        if (n2 < 0) {
            return null;
        }
        String string2 = string.substring(n2 + 1, string.length() - 1);
        return InternetAddress.parseHeader(string2, bl);
    }

    private static int indexOfAny(String string, String string2) {
        return InternetAddress.indexOfAny(string, string2, 0);
    }

    private static int indexOfAny(String string, String string2, int n2) {
        try {
            int n3 = string.length();
            for (int i2 = n2; i2 < n3; ++i2) {
                if (string2.indexOf(string.charAt(i2)) < 0) continue;
                return i2;
            }
            return -1;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return -1;
        }
    }
}

