/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import javax.mail.internet.ParseException;

public class HeaderTokenizer {
    private String string;
    private boolean skipComments;
    private String delimiters;
    private int currentPos;
    private int maxPos;
    private int nextPos;
    private int peekPos;
    public static final String RFC822 = "()<>@,;:\\\"\t .[]";
    public static final String MIME = "()<>@,;:\\\"\t []/?=";
    private static final Token EOFToken = new Token(-4, null);

    public HeaderTokenizer(String string, String string2, boolean bl) {
        this.string = string == null ? "" : string;
        this.skipComments = bl;
        this.delimiters = string2;
        this.peekPos = 0;
        this.nextPos = 0;
        this.currentPos = 0;
        this.maxPos = this.string.length();
    }

    public HeaderTokenizer(String string, String string2) {
        this(string, string2, true);
    }

    public HeaderTokenizer(String string) {
        this(string, RFC822);
    }

    public Token next() {
        return this.next('\u0000', false);
    }

    Token next(char c2) {
        return this.next(c2, false);
    }

    Token next(char c2, boolean bl) {
        this.currentPos = this.nextPos;
        Token token = this.getNext(c2, bl);
        this.nextPos = this.peekPos = this.currentPos;
        return token;
    }

    public Token peek() {
        this.currentPos = this.peekPos;
        Token token = this.getNext('\u0000', false);
        this.peekPos = this.currentPos;
        return token;
    }

    public String getRemainder() {
        return this.string.substring(this.nextPos);
    }

    private Token getNext(char c2, boolean bl) {
        int n2;
        if (this.currentPos >= this.maxPos) {
            return EOFToken;
        }
        if (this.skipWhiteSpace() == -4) {
            return EOFToken;
        }
        boolean bl2 = false;
        char c3 = this.string.charAt(this.currentPos);
        while (c3 == '(') {
            n2 = ++this.currentPos;
            int n3 = 1;
            while (n3 > 0 && this.currentPos < this.maxPos) {
                c3 = this.string.charAt(this.currentPos);
                if (c3 == '\\') {
                    ++this.currentPos;
                    bl2 = true;
                } else if (c3 == '\r') {
                    bl2 = true;
                } else if (c3 == '(') {
                    ++n3;
                } else if (c3 == ')') {
                    --n3;
                }
                ++this.currentPos;
            }
            if (n3 != 0) {
                throw new ParseException("Unbalanced comments");
            }
            if (!this.skipComments) {
                String string = bl2 ? HeaderTokenizer.filterToken(this.string, n2, this.currentPos - 1, bl) : this.string.substring(n2, this.currentPos - 1);
                return new Token(-3, string);
            }
            if (this.skipWhiteSpace() == -4) {
                return EOFToken;
            }
            c3 = this.string.charAt(this.currentPos);
        }
        if (c3 == '\"') {
            ++this.currentPos;
            return this.collectString('\"', bl);
        }
        if (c3 < ' ' || c3 >= '\u007f' || this.delimiters.indexOf(c3) >= 0) {
            if (c2 > '\u0000' && c3 != c2) {
                return this.collectString(c2, bl);
            }
            ++this.currentPos;
            char[] cArray = new char[]{c3};
            return new Token(c3, new String(cArray));
        }
        n2 = this.currentPos;
        while (this.currentPos < this.maxPos) {
            c3 = this.string.charAt(this.currentPos);
            if (c3 < ' ' || c3 >= '\u007f' || c3 == '(' || c3 == ' ' || c3 == '\"' || this.delimiters.indexOf(c3) >= 0) {
                if (c2 <= '\u0000' || c3 == c2) break;
                this.currentPos = n2;
                return this.collectString(c2, bl);
            }
            ++this.currentPos;
        }
        return new Token(-1, this.string.substring(n2, this.currentPos));
    }

    private Token collectString(char c2, boolean bl) {
        boolean bl2 = false;
        int n2 = this.currentPos;
        while (this.currentPos < this.maxPos) {
            char c3 = this.string.charAt(this.currentPos);
            if (c3 == '\\') {
                ++this.currentPos;
                bl2 = true;
            } else if (c3 == '\r') {
                bl2 = true;
            } else if (c3 == c2) {
                ++this.currentPos;
                String string = bl2 ? HeaderTokenizer.filterToken(this.string, n2, this.currentPos - 1, bl) : this.string.substring(n2, this.currentPos - 1);
                if (c3 != '\"') {
                    string = HeaderTokenizer.trimWhiteSpace(string);
                    --this.currentPos;
                }
                return new Token(-2, string);
            }
            ++this.currentPos;
        }
        if (c2 == '\"') {
            throw new ParseException("Unbalanced quoted string");
        }
        String string = bl2 ? HeaderTokenizer.filterToken(this.string, n2, this.currentPos, bl) : this.string.substring(n2, this.currentPos);
        string = HeaderTokenizer.trimWhiteSpace(string);
        return new Token(-2, string);
    }

    private int skipWhiteSpace() {
        while (this.currentPos < this.maxPos) {
            char c2 = this.string.charAt(this.currentPos);
            if (c2 != ' ' && c2 != '\t' && c2 != '\r' && c2 != '\n') {
                return this.currentPos;
            }
            ++this.currentPos;
        }
        return -4;
    }

    private static String trimWhiteSpace(String string) {
        char c2;
        int n2;
        for (n2 = string.length() - 1; n2 >= 0 && ((c2 = string.charAt(n2)) == ' ' || c2 == '\t' || c2 == '\r' || c2 == '\n'); --n2) {
        }
        if (n2 <= 0) {
            return "";
        }
        return string.substring(0, n2 + 1);
    }

    private static String filterToken(String string, int n2, int n3, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i2 = n2; i2 < n3; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '\n' && bl3) {
                bl3 = false;
                continue;
            }
            bl3 = false;
            if (!bl2) {
                if (c2 == '\\') {
                    bl2 = true;
                    continue;
                }
                if (c2 == '\r') {
                    bl3 = true;
                    continue;
                }
                stringBuffer.append(c2);
                continue;
            }
            if (bl) {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c2);
            bl2 = false;
        }
        return stringBuffer.toString();
    }

    public static class Token {
        private int type;
        private String value;
        public static final int ATOM = -1;
        public static final int QUOTEDSTRING = -2;
        public static final int COMMENT = -3;
        public static final int EOF = -4;

        public Token(int n2, String string) {
            this.type = n2;
            this.value = string;
        }

        public int getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }
    }
}

