/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import javax.mail.Service;
import javax.mail.Session;
import javax.mail.URLName;
import javax.mail.event.TransportEvent;
import javax.mail.event.TransportListener;

public abstract class Transport
extends Service {
    private volatile Vector transportListeners = null;

    public Transport(Session session, URLName uRLName) {
        super(session, uRLName);
    }

    public static void send(Message message) {
        message.saveChanges();
        Transport.send0(message, message.getAllRecipients());
    }

    public static void send(Message message, Address[] addressArray) {
        message.saveChanges();
        Transport.send0(message, addressArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void send0(Message message, Address[] addressArray) {
        Object[] objectArray;
        Object[] objectArray2;
        Object object;
        int n2;
        if (addressArray == null) throw new SendFailedException("No recipient addresses");
        if (addressArray.length == 0) {
            throw new SendFailedException("No recipient addresses");
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Vector<Object> vector = new Vector<Object>();
        Vector<Address> vector2 = new Vector<Address>();
        Vector<Address> vector3 = new Vector<Address>();
        for (n2 = 0; n2 < addressArray.length; ++n2) {
            if (hashtable.containsKey(addressArray[n2].getType())) {
                object = (Vector)hashtable.get(addressArray[n2].getType());
                ((Vector)object).addElement(addressArray[n2]);
                continue;
            }
            object = new Vector<Address>();
            ((Vector)object).addElement(addressArray[n2]);
            hashtable.put(addressArray[n2].getType(), object);
        }
        n2 = hashtable.size();
        if (n2 == 0) {
            throw new SendFailedException("No recipient addresses");
        }
        Object object2 = object = message.session != null ? message.session : Session.getDefaultInstance(System.getProperties(), null);
        if (n2 == 1) {
            Transport transport = ((Session)object).getTransport(addressArray[0]);
            try {
                transport.connect();
                transport.sendMessage(message, addressArray);
                Object var10_10 = null;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                transport.close();
                throw throwable;
            }
            transport.close();
            return;
        }
        MessagingException messagingException = null;
        boolean bl = false;
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            Object var19_26;
            objectArray2 = (Object[])enumeration.nextElement();
            objectArray = new Address[objectArray2.size()];
            objectArray2.copyInto(objectArray);
            Transport transport = ((Session)object).getTransport((Address)objectArray[0]);
            if (transport == null) {
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    vector.addElement(objectArray[i2]);
                }
                continue;
            }
            try {
                try {
                    transport.connect();
                    transport.sendMessage(message, (Address[])objectArray);
                }
                catch (SendFailedException sendFailedException) {
                    Address[] addressArray2;
                    int n3;
                    bl = true;
                    if (messagingException == null) {
                        messagingException = sendFailedException;
                    } else {
                        messagingException.setNextException(sendFailedException);
                    }
                    Address[] addressArray3 = sendFailedException.getInvalidAddresses();
                    if (addressArray3 != null) {
                        for (n3 = 0; n3 < addressArray3.length; ++n3) {
                            vector.addElement(addressArray3[n3]);
                        }
                    }
                    if ((addressArray3 = sendFailedException.getValidSentAddresses()) != null) {
                        for (n3 = 0; n3 < addressArray3.length; ++n3) {
                            vector2.addElement(addressArray3[n3]);
                        }
                    }
                    if ((addressArray2 = sendFailedException.getValidUnsentAddresses()) != null) {
                        for (int i3 = 0; i3 < addressArray2.length; ++i3) {
                            vector3.addElement(addressArray2[i3]);
                        }
                    }
                    var19_26 = null;
                    transport.close();
                    continue;
                }
                catch (MessagingException messagingException2) {
                    bl = true;
                    if (messagingException == null) {
                        messagingException = messagingException2;
                    } else {
                        messagingException.setNextException(messagingException2);
                    }
                    var19_26 = null;
                    transport.close();
                    continue;
                }
                var19_26 = null;
            }
            catch (Throwable throwable) {
                var19_26 = null;
                transport.close();
                throw throwable;
            }
            transport.close();
        }
        if (!bl && vector.size() == 0) {
            if (vector3.size() == 0) return;
        }
        objectArray2 = null;
        objectArray = null;
        Object[] objectArray3 = null;
        if (vector2.size() > 0) {
            objectArray2 = new Address[vector2.size()];
            vector2.copyInto(objectArray2);
        }
        if (vector3.size() > 0) {
            objectArray = new Address[vector3.size()];
            vector3.copyInto(objectArray);
        }
        if (vector.size() <= 0) throw new SendFailedException("Sending failed", messagingException, (Address[])objectArray2, (Address[])objectArray, (Address[])objectArray3);
        objectArray3 = new Address[vector.size()];
        vector.copyInto(objectArray3);
        throw new SendFailedException("Sending failed", messagingException, (Address[])objectArray2, (Address[])objectArray, (Address[])objectArray3);
    }

    public abstract void sendMessage(Message var1, Address[] var2);

    public synchronized void addTransportListener(TransportListener transportListener) {
        if (this.transportListeners == null) {
            this.transportListeners = new Vector();
        }
        this.transportListeners.addElement(transportListener);
    }

    public synchronized void removeTransportListener(TransportListener transportListener) {
        if (this.transportListeners != null) {
            this.transportListeners.removeElement(transportListener);
        }
    }

    protected void notifyTransportListeners(int n2, Address[] addressArray, Address[] addressArray2, Address[] addressArray3, Message message) {
        if (this.transportListeners == null) {
            return;
        }
        TransportEvent transportEvent = new TransportEvent(this, n2, addressArray, addressArray2, addressArray3, message);
        this.queueEvent(transportEvent, this.transportListeners);
    }
}

