/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;
import javax.mail.AuthenticationFailedException;
import javax.mail.EventQueue;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.URLName;
import javax.mail.event.ConnectionEvent;
import javax.mail.event.ConnectionListener;
import javax.mail.event.MailEvent;

public abstract class Service {
    protected Session session;
    protected URLName url = null;
    protected boolean debug = false;
    private boolean connected = false;
    private final Vector connectionListeners = new Vector();
    private EventQueue q;
    private Object qLock = new Object();

    protected Service(Session session, URLName uRLName) {
        this.session = session;
        this.url = uRLName;
        this.debug = session.getDebug();
    }

    public void connect() {
        this.connect(null, null, null);
    }

    public void connect(String string, String string2, String string3) {
        this.connect(string, -1, string2, string3);
    }

    public void connect(String string, String string2) {
        this.connect(null, string, string2);
    }

    public synchronized void connect(String string, int n2, String string2, String string3) {
        PasswordAuthentication passwordAuthentication;
        String string4;
        String string5;
        boolean bl;
        boolean bl2;
        block33: {
            if (this.isConnected()) {
                throw new IllegalStateException("already connected");
            }
            bl2 = false;
            bl = false;
            string5 = null;
            string4 = null;
            if (this.url != null) {
                string5 = this.url.getProtocol();
                if (string == null) {
                    string = this.url.getHost();
                }
                if (n2 == -1) {
                    n2 = this.url.getPort();
                }
                if (string2 == null) {
                    string2 = this.url.getUsername();
                    if (string3 == null) {
                        string3 = this.url.getPassword();
                    }
                } else if (string3 == null && string2.equals(this.url.getUsername())) {
                    string3 = this.url.getPassword();
                }
                string4 = this.url.getFile();
            }
            if (string5 != null) {
                if (string == null) {
                    string = this.session.getProperty("mail." + string5 + ".host");
                }
                if (string2 == null) {
                    string2 = this.session.getProperty("mail." + string5 + ".user");
                }
            }
            if (string == null) {
                string = this.session.getProperty("mail.host");
            }
            if (string2 == null) {
                string2 = this.session.getProperty("mail.user");
            }
            if (string2 == null) {
                try {
                    string2 = System.getProperty("user.name");
                }
                catch (SecurityException securityException) {
                    if (!this.debug) break block33;
                    securityException.printStackTrace(this.session.getDebugOut());
                }
            }
        }
        if (string3 == null && this.url != null) {
            this.setURLName(new URLName(string5, string, n2, string4, string2, null));
            passwordAuthentication = this.session.getPasswordAuthentication(this.getURLName());
            if (passwordAuthentication != null) {
                if (string2 == null) {
                    string2 = passwordAuthentication.getUserName();
                    string3 = passwordAuthentication.getPassword();
                } else if (string2.equals(passwordAuthentication.getUserName())) {
                    string3 = passwordAuthentication.getPassword();
                }
            } else {
                bl = true;
            }
        }
        AuthenticationFailedException authenticationFailedException = null;
        try {
            bl2 = this.protocolConnect(string, n2, string2, string3);
        }
        catch (AuthenticationFailedException authenticationFailedException2) {
            authenticationFailedException = authenticationFailedException2;
        }
        if (!bl2) {
            InetAddress inetAddress;
            try {
                inetAddress = InetAddress.getByName(string);
            }
            catch (UnknownHostException unknownHostException) {
                inetAddress = null;
            }
            passwordAuthentication = this.session.requestPasswordAuthentication(inetAddress, n2, string5, null, string2);
            if (passwordAuthentication != null) {
                string2 = passwordAuthentication.getUserName();
                string3 = passwordAuthentication.getPassword();
                bl2 = this.protocolConnect(string, n2, string2, string3);
            }
        }
        if (!bl2) {
            if (authenticationFailedException != null) {
                throw authenticationFailedException;
            }
            if (string2 == null) {
                throw new AuthenticationFailedException("failed to connect, no user name specified?");
            }
            if (string3 == null) {
                throw new AuthenticationFailedException("failed to connect, no password specified?");
            }
            throw new AuthenticationFailedException("failed to connect");
        }
        this.setURLName(new URLName(string5, string, n2, string4, string2, string3));
        if (bl) {
            this.session.setPasswordAuthentication(this.getURLName(), new PasswordAuthentication(string2, string3));
        }
        this.setConnected(true);
        this.notifyConnectionListeners(1);
    }

    protected boolean protocolConnect(String string, int n2, String string2, String string3) {
        return false;
    }

    public synchronized boolean isConnected() {
        return this.connected;
    }

    protected synchronized void setConnected(boolean bl) {
        this.connected = bl;
    }

    public synchronized void close() {
        this.setConnected(false);
        this.notifyConnectionListeners(3);
    }

    public synchronized URLName getURLName() {
        if (this.url != null && (this.url.getPassword() != null || this.url.getFile() != null)) {
            return new URLName(this.url.getProtocol(), this.url.getHost(), this.url.getPort(), null, this.url.getUsername(), null);
        }
        return this.url;
    }

    protected synchronized void setURLName(URLName uRLName) {
        this.url = uRLName;
    }

    public void addConnectionListener(ConnectionListener connectionListener) {
        this.connectionListeners.addElement(connectionListener);
    }

    public void removeConnectionListener(ConnectionListener connectionListener) {
        this.connectionListeners.removeElement(connectionListener);
    }

    protected void notifyConnectionListeners(int n2) {
        if (this.connectionListeners.size() > 0) {
            ConnectionEvent connectionEvent = new ConnectionEvent(this, n2);
            this.queueEvent(connectionEvent, this.connectionListeners);
        }
        if (n2 == 3) {
            this.terminateQueue();
        }
    }

    public String toString() {
        URLName uRLName = this.getURLName();
        if (uRLName != null) {
            return uRLName.toString();
        }
        return super.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void queueEvent(MailEvent mailEvent, Vector vector) {
        Object object = this.qLock;
        synchronized (object) {
            if (this.q == null) {
                this.q = new EventQueue();
            }
        }
        object = (Vector)vector.clone();
        this.q.enqueue(mailEvent, (Vector)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminateQueue() {
        Object object = this.qLock;
        synchronized (object) {
            if (this.q != null) {
                Vector vector = new Vector();
                vector.setSize(1);
                this.q.enqueue(new TerminatorEvent(), vector);
                this.q = null;
            }
        }
    }

    protected void finalize() {
        super.finalize();
        this.terminateQueue();
    }

    static class TerminatorEvent
    extends MailEvent {
        private static final long serialVersionUID = 5542172141759168416L;

        TerminatorEvent() {
            super(new Object());
        }

        public void dispatch(Object object) {
            Thread.currentThread().interrupt();
        }
    }
}

