/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import java.io.InvalidObjectException;
import java.io.Serializable;
import java.util.Date;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.MethodNotSupportedException;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.search.SearchTerm;

public abstract class Message
implements Part {
    protected int msgnum = 0;
    protected boolean expunged = false;
    protected Folder folder = null;
    protected Session session = null;

    protected Message() {
    }

    protected Message(Folder folder, int n2) {
        this.folder = folder;
        this.msgnum = n2;
        this.session = folder.store.session;
    }

    protected Message(Session session) {
        this.session = session;
    }

    public abstract Address[] getFrom();

    public abstract void setFrom();

    public abstract void setFrom(Address var1);

    public abstract void addFrom(Address[] var1);

    public abstract Address[] getRecipients(RecipientType var1);

    public Address[] getAllRecipients() {
        Address[] addressArray = this.getRecipients(RecipientType.TO);
        Address[] addressArray2 = this.getRecipients(RecipientType.CC);
        Address[] addressArray3 = this.getRecipients(RecipientType.BCC);
        if (addressArray2 == null && addressArray3 == null) {
            return addressArray;
        }
        int n2 = (addressArray != null ? addressArray.length : 0) + (addressArray2 != null ? addressArray2.length : 0) + (addressArray3 != null ? addressArray3.length : 0);
        Address[] addressArray4 = new Address[n2];
        int n3 = 0;
        if (addressArray != null) {
            System.arraycopy(addressArray, 0, addressArray4, n3, addressArray.length);
            n3 += addressArray.length;
        }
        if (addressArray2 != null) {
            System.arraycopy(addressArray2, 0, addressArray4, n3, addressArray2.length);
            n3 += addressArray2.length;
        }
        if (addressArray3 != null) {
            System.arraycopy(addressArray3, 0, addressArray4, n3, addressArray3.length);
            n3 += addressArray3.length;
        }
        return addressArray4;
    }

    public abstract void setRecipients(RecipientType var1, Address[] var2);

    public void setRecipient(RecipientType recipientType, Address address) {
        Address[] addressArray = new Address[]{address};
        this.setRecipients(recipientType, addressArray);
    }

    public abstract void addRecipients(RecipientType var1, Address[] var2);

    public void addRecipient(RecipientType recipientType, Address address) {
        Address[] addressArray = new Address[]{address};
        this.addRecipients(recipientType, addressArray);
    }

    public Address[] getReplyTo() {
        return this.getFrom();
    }

    public void setReplyTo(Address[] addressArray) {
        throw new MethodNotSupportedException("setReplyTo not supported");
    }

    public abstract String getSubject();

    public abstract void setSubject(String var1);

    public abstract Date getSentDate();

    public abstract void setSentDate(Date var1);

    public abstract Date getReceivedDate();

    public abstract Flags getFlags();

    public boolean isSet(Flags.Flag flag) {
        return this.getFlags().contains(flag);
    }

    public abstract void setFlags(Flags var1, boolean var2);

    public void setFlag(Flags.Flag flag, boolean bl) {
        Flags flags = new Flags(flag);
        this.setFlags(flags, bl);
    }

    public int getMessageNumber() {
        return this.msgnum;
    }

    protected void setMessageNumber(int n2) {
        this.msgnum = n2;
    }

    public Folder getFolder() {
        return this.folder;
    }

    public boolean isExpunged() {
        return this.expunged;
    }

    protected void setExpunged(boolean bl) {
        this.expunged = bl;
    }

    public abstract Message reply(boolean var1);

    public abstract void saveChanges();

    public boolean match(SearchTerm searchTerm) {
        return searchTerm.match(this);
    }

    public static class RecipientType
    implements Serializable {
        public static final RecipientType TO = new RecipientType("To");
        public static final RecipientType CC = new RecipientType("Cc");
        public static final RecipientType BCC = new RecipientType("Bcc");
        protected String type;
        private static final long serialVersionUID = -7479791750606340008L;

        protected RecipientType(String string) {
            this.type = string;
        }

        protected Object readResolve() {
            if (this.type.equals("To")) {
                return TO;
            }
            if (this.type.equals("Cc")) {
                return CC;
            }
            if (this.type.equals("Bcc")) {
                return BCC;
            }
            throw new InvalidObjectException("Attempt to resolve unknown RecipientType: " + this.type);
        }

        public String toString() {
            return this.type;
        }
    }
}

