/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.rolling.RolloverFailure;
import ch.qos.logback.core.spi.ContextAwareBase;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class FileUtil
extends ContextAwareBase {
    static final int BUF_SIZE = 32768;

    public FileUtil(Context context) {
        this.setContext(context);
    }

    public static URL fileToURL(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException("Unexpected exception on file [" + file + "]", malformedURLException);
        }
    }

    public static boolean createMissingParentDirectories(File file) {
        File file2 = file.getParentFile();
        if (file2 == null) {
            return true;
        }
        file2.mkdirs();
        return file2.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String resourceAsString(ClassLoader classLoader, String string) {
        URL uRL = classLoader.getResource(string);
        if (uRL == null) {
            this.addError("Failed to find resource [" + string + "]");
            return null;
        }
        InputStreamReader inputStreamReader = null;
        try {
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setUseCaches(false);
            inputStreamReader = new InputStreamReader(uRLConnection.getInputStream());
            char[] cArray = new char[128];
            StringBuilder stringBuilder = new StringBuilder();
            int n = -1;
            while ((n = inputStreamReader.read(cArray, 0, cArray.length)) != -1) {
                stringBuilder.append(cArray, 0, n);
            }
            String string2 = stringBuilder.toString();
            return string2;
        }
        catch (IOException iOException) {
            this.addError("Failed to open " + string, iOException);
        }
        finally {
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public void copy(String string, String string2) {
        BufferedInputStream bufferedInputStream = null;
        FilterOutputStream filterOutputStream = null;
        try {
            int n;
            bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            filterOutputStream = new BufferedOutputStream(new FileOutputStream(string2));
            byte[] byArray = new byte[32768];
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n);
            }
            bufferedInputStream.close();
            bufferedInputStream = null;
            filterOutputStream.close();
            filterOutputStream = null;
        }
        catch (IOException iOException) {
            String string3 = "Failed to copy [" + string + "] to [" + string2 + "]";
            this.addError(string3, iOException);
            throw new RolloverFailure(string3);
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

