/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.spi.ContextAwareBase;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

public class ContextUtil
extends ContextAwareBase {
    public ContextUtil(Context context) {
        this.setContext(context);
    }

    public static String getLocalHostName() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            return inetAddress.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return ContextUtil.getLocalAddressAsString();
        }
    }

    private static String getLocalAddressAsString() {
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        while (enumeration != null && enumeration.hasMoreElements()) {
            Enumeration<InetAddress> enumeration2 = enumeration.nextElement().getInetAddresses();
            while (enumeration2 != null && enumeration2.hasMoreElements()) {
                InetAddress inetAddress = enumeration2.nextElement();
                if (!ContextUtil.acceptableAddress(inetAddress)) continue;
                return inetAddress.getHostAddress();
            }
        }
        throw new UnknownHostException();
    }

    private static boolean acceptableAddress(InetAddress inetAddress) {
        return inetAddress != null && !inetAddress.isLoopbackAddress() && !inetAddress.isAnyLocalAddress() && !inetAddress.isLinkLocalAddress();
    }

    public void addHostNameAsProperty() {
        try {
            String string = ContextUtil.getLocalHostName();
            this.context.putProperty("HOSTNAME", string);
        }
        catch (UnknownHostException unknownHostException) {
            this.addError("Failed to get local hostname", unknownHostException);
        }
        catch (SocketException socketException) {
            this.addError("Failed to get local hostname", socketException);
        }
        catch (SecurityException securityException) {
            this.addError("Failed to get local hostname", securityException);
        }
    }

    public void addProperties(Properties properties) {
        if (properties == null) {
            return;
        }
        for (String string : properties.keySet()) {
            this.context.putProperty(string, properties.getProperty(string));
        }
    }

    public void addGroovyPackages(List<String> list) {
        this.addFrameworkPackage(list, "org.codehaus.groovy.runtime");
    }

    public void addFrameworkPackage(List<String> list, String string) {
        if (!list.contains(string)) {
            list.add(string);
        }
    }
}

