/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.subst;

import ch.qos.logback.core.spi.ScanException;
import ch.qos.logback.core.subst.Token;
import java.util.ArrayList;
import java.util.List;

public class Tokenizer {
    final String pattern;
    final int patternLength;
    TokenizerState state = TokenizerState.LITERAL_STATE;
    int pointer = 0;

    public Tokenizer(String string) {
        this.pattern = string;
        this.patternLength = string.length();
    }

    List<Token> tokenize() {
        ArrayList<Token> arrayList = new ArrayList<Token>();
        StringBuilder stringBuilder = new StringBuilder();
        while (this.pointer < this.patternLength) {
            char c = this.pattern.charAt(this.pointer);
            ++this.pointer;
            switch (this.state) {
                case LITERAL_STATE: {
                    this.handleLiteralState(c, arrayList, stringBuilder);
                    break;
                }
                case START_STATE: {
                    this.handleStartState(c, arrayList, stringBuilder);
                    break;
                }
                case DEFAULT_VAL_STATE: {
                    this.handleDefaultValueState(c, arrayList, stringBuilder);
                }
            }
        }
        switch (this.state) {
            case LITERAL_STATE: {
                this.addLiteralToken(arrayList, stringBuilder);
                break;
            }
            case START_STATE: {
                throw new ScanException("Unexpected end of pattern string");
            }
        }
        return arrayList;
    }

    private void handleDefaultValueState(char c, List<Token> list, StringBuilder stringBuilder) {
        switch (c) {
            case '-': {
                list.add(Token.DEFAULT_SEP_TOKEN);
                this.state = TokenizerState.LITERAL_STATE;
                break;
            }
            case '$': {
                stringBuilder.append(':');
                this.addLiteralToken(list, stringBuilder);
                stringBuilder.setLength(0);
                this.state = TokenizerState.START_STATE;
                break;
            }
            default: {
                stringBuilder.append(':').append(c);
                this.state = TokenizerState.LITERAL_STATE;
            }
        }
    }

    private void handleStartState(char c, List<Token> list, StringBuilder stringBuilder) {
        if (c == '{') {
            list.add(Token.START_TOKEN);
        } else {
            stringBuilder.append('$').append(c);
        }
        this.state = TokenizerState.LITERAL_STATE;
    }

    private void handleLiteralState(char c, List<Token> list, StringBuilder stringBuilder) {
        if (c == '$') {
            this.addLiteralToken(list, stringBuilder);
            stringBuilder.setLength(0);
            this.state = TokenizerState.START_STATE;
        } else if (c == ':') {
            this.addLiteralToken(list, stringBuilder);
            stringBuilder.setLength(0);
            this.state = TokenizerState.DEFAULT_VAL_STATE;
        } else if (c == '{') {
            this.addLiteralToken(list, stringBuilder);
            list.add(Token.CURLY_LEFT_TOKEN);
            stringBuilder.setLength(0);
        } else if (c == '}') {
            this.addLiteralToken(list, stringBuilder);
            list.add(Token.CURLY_RIGHT_TOKEN);
            stringBuilder.setLength(0);
        } else {
            stringBuilder.append(c);
        }
    }

    private void addLiteralToken(List<Token> list, StringBuilder stringBuilder) {
        if (stringBuilder.length() == 0) {
            return;
        }
        list.add(new Token(Token.Type.LITERAL, stringBuilder.toString()));
    }

    static enum TokenizerState {
        LITERAL_STATE,
        START_STATE,
        DEFAULT_VAL_STATE;

    }
}

