/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.spi;

import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterAttachable;
import ch.qos.logback.core.spi.FilterReply;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public final class FilterAttachableImpl<E>
implements FilterAttachable<E> {
    CopyOnWriteArrayList<Filter<E>> filterList = new CopyOnWriteArrayList();

    @Override
    public void addFilter(Filter<E> filter) {
        this.filterList.add(filter);
    }

    @Override
    public void clearAllFilters() {
        this.filterList.clear();
    }

    @Override
    public FilterReply getFilterChainDecision(E e) {
        for (Filter<E> filter : this.filterList) {
            FilterReply filterReply = filter.decide(e);
            if (filterReply != FilterReply.DENY && filterReply != FilterReply.ACCEPT) continue;
            return filterReply;
        }
        return FilterReply.NEUTRAL;
    }

    @Override
    public List<Filter<E>> getCopyOfAttachedFiltersList() {
        return new ArrayList<Filter<E>>(this.filterList);
    }
}

