/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.LiteralConverter;
import ch.qos.logback.core.rolling.helper.ArchiveRemover;
import ch.qos.logback.core.rolling.helper.DateTokenConverter;
import ch.qos.logback.core.rolling.helper.FileFilterUtil;
import ch.qos.logback.core.rolling.helper.FileNamePattern;
import ch.qos.logback.core.rolling.helper.RollingCalendar;
import ch.qos.logback.core.spi.ContextAwareBase;
import java.io.File;
import java.util.Date;

public abstract class DefaultArchiveRemover
extends ContextAwareBase
implements ArchiveRemover {
    protected static final long UNINITIALIZED = -1L;
    protected static final long INACTIVITY_TOLERANCE_IN_MILLIS = 5529600000L;
    static final int MAX_VALUE_FOR_INACTIVITY_PERIODS = 336;
    final FileNamePattern fileNamePattern;
    final RollingCalendar rc;
    int periodOffsetForDeletionTarget;
    final boolean parentClean;
    long lastHeartBeat = -1L;

    public DefaultArchiveRemover(FileNamePattern fileNamePattern, RollingCalendar rollingCalendar) {
        this.fileNamePattern = fileNamePattern;
        this.rc = rollingCalendar;
        this.parentClean = this.computeParentCleaningFlag(fileNamePattern);
    }

    int computeElapsedPeriodsSinceLastClean(long l) {
        long l2 = 0L;
        if (this.lastHeartBeat == -1L) {
            this.addInfo("first clean up after appender initialization");
            l2 = this.rc.periodsElapsed(l, l + 5529600000L);
            if (l2 > 336L) {
                l2 = 336L;
            }
        } else {
            l2 = this.rc.periodsElapsed(this.lastHeartBeat, l);
            if (l2 < 1L) {
                this.addWarn("Unexpected periodsElapsed value " + l2);
                l2 = 1L;
            }
        }
        return (int)l2;
    }

    @Override
    public void clean(Date date) {
        long l = date.getTime();
        int n = this.computeElapsedPeriodsSinceLastClean(l);
        this.lastHeartBeat = l;
        if (n > 1) {
            this.addInfo("periodsElapsed = " + n);
        }
        for (int i = 0; i < n; ++i) {
            this.cleanByPeriodOffset(date, this.periodOffsetForDeletionTarget - i);
        }
    }

    abstract void cleanByPeriodOffset(Date var1, int var2);

    boolean computeParentCleaningFlag(FileNamePattern fileNamePattern) {
        Converter<Object> converter;
        DateTokenConverter dateTokenConverter = fileNamePattern.getPrimaryDateTokenConverter();
        if (dateTokenConverter.getDatePattern().indexOf(47) != -1) {
            return true;
        }
        for (converter = fileNamePattern.headTokenConverter; converter != null && !(converter instanceof DateTokenConverter); converter = converter.getNext()) {
        }
        while (converter != null) {
            String string;
            if (converter instanceof LiteralConverter && (string = converter.convert(null)).indexOf(47) != -1) {
                return true;
            }
            converter = converter.getNext();
        }
        return false;
    }

    void removeFolderIfEmpty(File file) {
        this.removeFolderIfEmpty(file, 0);
    }

    private void removeFolderIfEmpty(File file, int n) {
        if (n >= 3) {
            return;
        }
        if (file.isDirectory() && FileFilterUtil.isEmptyDirectory(file)) {
            this.addInfo("deleting folder [" + file + "]");
            file.delete();
            this.removeFolderIfEmpty(file.getParentFile(), n + 1);
        }
    }

    @Override
    public void setMaxHistory(int n) {
        this.periodOffsetForDeletionTarget = -n - 1;
    }
}

