/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.rolling.DefaultTimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.RollingPolicyBase;
import ch.qos.logback.core.rolling.TimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.TriggeringPolicy;
import ch.qos.logback.core.rolling.helper.ArchiveRemover;
import ch.qos.logback.core.rolling.helper.AsynchronousCompressor;
import ch.qos.logback.core.rolling.helper.CompressionMode;
import ch.qos.logback.core.rolling.helper.Compressor;
import ch.qos.logback.core.rolling.helper.FileFilterUtil;
import ch.qos.logback.core.rolling.helper.FileNamePattern;
import ch.qos.logback.core.rolling.helper.RenameUtil;
import java.io.File;
import java.util.Date;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class TimeBasedRollingPolicy<E>
extends RollingPolicyBase
implements TriggeringPolicy<E> {
    static final String FNP_NOT_SET = "The FileNamePattern option must be set before using TimeBasedRollingPolicy. ";
    static final int INFINITE_HISTORY = 0;
    FileNamePattern fileNamePatternWCS;
    private Compressor compressor;
    private RenameUtil renameUtil = new RenameUtil();
    Future<?> future;
    private int maxHistory = 0;
    private ArchiveRemover archiveRemover;
    TimeBasedFileNamingAndTriggeringPolicy<E> timeBasedFileNamingAndTriggeringPolicy;
    boolean cleanHistoryOnStart = false;

    @Override
    public void start() {
        this.renameUtil.setContext(this.context);
        if (this.fileNamePatternStr == null) {
            this.addWarn(FNP_NOT_SET);
            this.addWarn("See also http://logback.qos.ch/codes.html#tbr_fnp_not_set");
            throw new IllegalStateException("The FileNamePattern option must be set before using TimeBasedRollingPolicy. See also http://logback.qos.ch/codes.html#tbr_fnp_not_set");
        }
        this.fileNamePattern = new FileNamePattern(this.fileNamePatternStr, this.context);
        this.determineCompressionMode();
        this.compressor = new Compressor(this.compressionMode);
        this.compressor.setContext(this.context);
        this.fileNamePatternWCS = new FileNamePattern(Compressor.computeFileNameStr_WCS(this.fileNamePatternStr, this.compressionMode), this.context);
        this.addInfo("Will use the pattern " + this.fileNamePatternWCS + " for the active file");
        if (this.compressionMode == CompressionMode.ZIP) {
            String string = this.transformFileNamePattern2ZipEntry(this.fileNamePatternStr);
            this.zipEntryFileNamePattern = new FileNamePattern(string, this.context);
        }
        if (this.timeBasedFileNamingAndTriggeringPolicy == null) {
            this.timeBasedFileNamingAndTriggeringPolicy = new DefaultTimeBasedFileNamingAndTriggeringPolicy();
        }
        this.timeBasedFileNamingAndTriggeringPolicy.setContext(this.context);
        this.timeBasedFileNamingAndTriggeringPolicy.setTimeBasedRollingPolicy(this);
        this.timeBasedFileNamingAndTriggeringPolicy.start();
        if (this.maxHistory != 0) {
            this.archiveRemover = this.timeBasedFileNamingAndTriggeringPolicy.getArchiveRemover();
            this.archiveRemover.setMaxHistory(this.maxHistory);
            if (this.cleanHistoryOnStart) {
                this.addInfo("Cleaning on start up");
                this.archiveRemover.clean(new Date(this.timeBasedFileNamingAndTriggeringPolicy.getCurrentTime()));
            }
        }
        super.start();
    }

    @Override
    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        this.waitForAsynchronousJobToStop();
        super.stop();
    }

    private void waitForAsynchronousJobToStop() {
        if (this.future != null) {
            try {
                this.future.get(30L, TimeUnit.SECONDS);
            }
            catch (TimeoutException timeoutException) {
                this.addError("Timeout while waiting for compression job to finish", timeoutException);
            }
            catch (Exception exception) {
                this.addError("Unexpected exception while waiting for compression job to finish", exception);
            }
        }
    }

    private String transformFileNamePattern2ZipEntry(String string) {
        String string2 = FileFilterUtil.slashify(string);
        return FileFilterUtil.afterLastSlash(string2);
    }

    public void setTimeBasedFileNamingAndTriggeringPolicy(TimeBasedFileNamingAndTriggeringPolicy<E> timeBasedFileNamingAndTriggeringPolicy) {
        this.timeBasedFileNamingAndTriggeringPolicy = timeBasedFileNamingAndTriggeringPolicy;
    }

    public TimeBasedFileNamingAndTriggeringPolicy<E> getTimeBasedFileNamingAndTriggeringPolicy() {
        return this.timeBasedFileNamingAndTriggeringPolicy;
    }

    @Override
    public void rollover() {
        String string = this.timeBasedFileNamingAndTriggeringPolicy.getElapsedPeriodsFileName();
        String string2 = FileFilterUtil.afterLastSlash(string);
        if (this.compressionMode == CompressionMode.NONE) {
            if (this.getParentsRawFileProperty() != null) {
                this.renameUtil.rename(this.getParentsRawFileProperty(), string);
            }
        } else {
            this.future = this.getParentsRawFileProperty() == null ? this.asyncCompress(string, string, string2) : this.renamedRawAndAsyncCompress(string, string2);
        }
        if (this.archiveRemover != null) {
            this.archiveRemover.clean(new Date(this.timeBasedFileNamingAndTriggeringPolicy.getCurrentTime()));
        }
    }

    Future asyncCompress(String string, String string2, String string3) {
        AsynchronousCompressor asynchronousCompressor = new AsynchronousCompressor(this.compressor);
        return asynchronousCompressor.compressAsynchronously(string, string2, string3);
    }

    Future renamedRawAndAsyncCompress(String string, String string2) {
        String string3 = this.getParentsRawFileProperty();
        String string4 = string3 + System.nanoTime() + ".tmp";
        this.renameUtil.rename(string3, string4);
        return this.asyncCompress(string4, string, string2);
    }

    @Override
    public String getActiveFileName() {
        String string = this.getParentsRawFileProperty();
        if (string != null) {
            return string;
        }
        return this.timeBasedFileNamingAndTriggeringPolicy.getCurrentPeriodsFileNameWithoutCompressionSuffix();
    }

    @Override
    public boolean isTriggeringEvent(File file, E e) {
        return this.timeBasedFileNamingAndTriggeringPolicy.isTriggeringEvent(file, e);
    }

    public int getMaxHistory() {
        return this.maxHistory;
    }

    public void setMaxHistory(int n) {
        this.maxHistory = n;
    }

    public boolean isCleanHistoryOnStart() {
        return this.cleanHistoryOnStart;
    }

    public void setCleanHistoryOnStart(boolean bl) {
        this.cleanHistoryOnStart = bl;
    }

    public String toString() {
        return "c.q.l.core.rolling.TimeBasedRollingPolicy";
    }
}

