/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.rolling.TimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.rolling.helper.ArchiveRemover;
import ch.qos.logback.core.rolling.helper.DateTokenConverter;
import ch.qos.logback.core.rolling.helper.RollingCalendar;
import ch.qos.logback.core.spi.ContextAwareBase;
import java.io.File;
import java.util.Date;

public abstract class TimeBasedFileNamingAndTriggeringPolicyBase<E>
extends ContextAwareBase
implements TimeBasedFileNamingAndTriggeringPolicy<E> {
    protected TimeBasedRollingPolicy<E> tbrp;
    protected ArchiveRemover archiveRemover = null;
    protected String elapsedPeriodsFileName;
    protected RollingCalendar rc;
    protected long artificialCurrentTime = -1L;
    protected Date dateInCurrentPeriod = null;
    protected long nextCheck;
    protected boolean started = false;

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public void start() {
        File file;
        DateTokenConverter dateTokenConverter = this.tbrp.fileNamePattern.getPrimaryDateTokenConverter();
        if (dateTokenConverter == null) {
            throw new IllegalStateException("FileNamePattern [" + this.tbrp.fileNamePattern.getPattern() + "] does not contain a valid DateToken");
        }
        this.rc = new RollingCalendar();
        this.rc.init(dateTokenConverter.getDatePattern());
        this.addInfo("The date pattern is '" + dateTokenConverter.getDatePattern() + "' from file name pattern '" + this.tbrp.fileNamePattern.getPattern() + "'.");
        this.rc.printPeriodicity(this);
        this.setDateInCurrentPeriod(new Date(this.getCurrentTime()));
        if (this.tbrp.getParentsRawFileProperty() != null && (file = new File(this.tbrp.getParentsRawFileProperty())).exists() && file.canRead()) {
            this.setDateInCurrentPeriod(new Date(file.lastModified()));
        }
        this.addInfo("Setting initial period to " + this.dateInCurrentPeriod);
        this.computeNextCheck();
    }

    @Override
    public void stop() {
        this.started = false;
    }

    protected void computeNextCheck() {
        this.nextCheck = this.rc.getNextTriggeringMillis(this.dateInCurrentPeriod);
    }

    protected void setDateInCurrentPeriod(long l) {
        this.dateInCurrentPeriod.setTime(l);
    }

    public void setDateInCurrentPeriod(Date date) {
        this.dateInCurrentPeriod = date;
    }

    @Override
    public String getElapsedPeriodsFileName() {
        return this.elapsedPeriodsFileName;
    }

    @Override
    public String getCurrentPeriodsFileNameWithoutCompressionSuffix() {
        return this.tbrp.fileNamePatternWCS.convert(this.dateInCurrentPeriod);
    }

    @Override
    public void setCurrentTime(long l) {
        this.artificialCurrentTime = l;
    }

    @Override
    public long getCurrentTime() {
        if (this.artificialCurrentTime >= 0L) {
            return this.artificialCurrentTime;
        }
        return System.currentTimeMillis();
    }

    @Override
    public void setTimeBasedRollingPolicy(TimeBasedRollingPolicy<E> timeBasedRollingPolicy) {
        this.tbrp = timeBasedRollingPolicy;
    }

    @Override
    public ArchiveRemover getArchiveRemover() {
        return this.archiveRemover;
    }
}

