/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern.parser;

import ch.qos.logback.core.pattern.parser.OptionTokenizer;
import ch.qos.logback.core.pattern.parser.Token;
import ch.qos.logback.core.pattern.util.IEscapeUtil;
import ch.qos.logback.core.pattern.util.RegularEscapeUtil;
import ch.qos.logback.core.pattern.util.RestrictedEscapeUtil;
import ch.qos.logback.core.spi.ScanException;
import java.util.ArrayList;
import java.util.List;

class TokenStream {
    final String pattern;
    final int patternLength;
    final IEscapeUtil escapeUtil;
    final IEscapeUtil optionEscapeUtil = new RestrictedEscapeUtil();
    TokenizerState state = TokenizerState.LITERAL_STATE;
    int pointer = 0;

    TokenStream(String string) {
        this(string, new RegularEscapeUtil());
    }

    TokenStream(String string, IEscapeUtil iEscapeUtil) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("null or empty pattern string not allowed");
        }
        this.pattern = string;
        this.patternLength = string.length();
        this.escapeUtil = iEscapeUtil;
    }

    List tokenize() {
        ArrayList<Token> arrayList = new ArrayList<Token>();
        StringBuffer stringBuffer = new StringBuffer();
        while (this.pointer < this.patternLength) {
            char c = this.pattern.charAt(this.pointer);
            ++this.pointer;
            switch (this.state) {
                case LITERAL_STATE: {
                    this.handleLiteralState(c, arrayList, stringBuffer);
                    break;
                }
                case FORMAT_MODIFIER_STATE: {
                    this.handleFormatModifierState(c, arrayList, stringBuffer);
                    break;
                }
                case OPTION_STATE: {
                    this.processOption(c, arrayList, stringBuffer);
                    break;
                }
                case KEYWORD_STATE: {
                    this.handleKeywordState(c, arrayList, stringBuffer);
                    break;
                }
                case RIGHT_PARENTHESIS_STATE: {
                    this.handleRightParenthesisState(c, arrayList, stringBuffer);
                    break;
                }
            }
        }
        switch (this.state) {
            case LITERAL_STATE: {
                this.addValuedToken(1000, stringBuffer, arrayList);
                break;
            }
            case KEYWORD_STATE: {
                arrayList.add(new Token(1004, stringBuffer.toString()));
                break;
            }
            case RIGHT_PARENTHESIS_STATE: {
                arrayList.add(Token.RIGHT_PARENTHESIS_TOKEN);
                break;
            }
            case FORMAT_MODIFIER_STATE: 
            case OPTION_STATE: {
                throw new ScanException("Unexpected end of pattern string");
            }
        }
        return arrayList;
    }

    private void handleRightParenthesisState(char c, List<Token> list, StringBuffer stringBuffer) {
        list.add(Token.RIGHT_PARENTHESIS_TOKEN);
        switch (c) {
            case ')': {
                break;
            }
            case '{': {
                this.state = TokenizerState.OPTION_STATE;
                break;
            }
            case '\\': {
                this.escape("%{}", stringBuffer);
                this.state = TokenizerState.LITERAL_STATE;
                break;
            }
            default: {
                stringBuffer.append(c);
                this.state = TokenizerState.LITERAL_STATE;
            }
        }
    }

    private void processOption(char c, List<Token> list, StringBuffer stringBuffer) {
        OptionTokenizer optionTokenizer = new OptionTokenizer(this);
        optionTokenizer.tokenize(c, list);
    }

    private void handleFormatModifierState(char c, List<Token> list, StringBuffer stringBuffer) {
        if (c == '(') {
            this.addValuedToken(1002, stringBuffer, list);
            list.add(Token.BARE_COMPOSITE_KEYWORD_TOKEN);
            this.state = TokenizerState.LITERAL_STATE;
        } else if (Character.isJavaIdentifierStart(c)) {
            this.addValuedToken(1002, stringBuffer, list);
            this.state = TokenizerState.KEYWORD_STATE;
            stringBuffer.append(c);
        } else {
            stringBuffer.append(c);
        }
    }

    private void handleLiteralState(char c, List<Token> list, StringBuffer stringBuffer) {
        switch (c) {
            case '\\': {
                this.escape("%()", stringBuffer);
                break;
            }
            case '%': {
                this.addValuedToken(1000, stringBuffer, list);
                list.add(Token.PERCENT_TOKEN);
                this.state = TokenizerState.FORMAT_MODIFIER_STATE;
                break;
            }
            case ')': {
                this.addValuedToken(1000, stringBuffer, list);
                this.state = TokenizerState.RIGHT_PARENTHESIS_STATE;
                break;
            }
            default: {
                stringBuffer.append(c);
            }
        }
    }

    private void handleKeywordState(char c, List<Token> list, StringBuffer stringBuffer) {
        if (Character.isJavaIdentifierPart(c)) {
            stringBuffer.append(c);
        } else if (c == '{') {
            this.addValuedToken(1004, stringBuffer, list);
            this.state = TokenizerState.OPTION_STATE;
        } else if (c == '(') {
            this.addValuedToken(1005, stringBuffer, list);
            this.state = TokenizerState.LITERAL_STATE;
        } else if (c == '%') {
            this.addValuedToken(1004, stringBuffer, list);
            list.add(Token.PERCENT_TOKEN);
            this.state = TokenizerState.FORMAT_MODIFIER_STATE;
        } else if (c == ')') {
            this.addValuedToken(1004, stringBuffer, list);
            this.state = TokenizerState.RIGHT_PARENTHESIS_STATE;
        } else {
            this.addValuedToken(1004, stringBuffer, list);
            if (c == '\\') {
                if (this.pointer < this.patternLength) {
                    char c2 = this.pattern.charAt(this.pointer++);
                    this.escapeUtil.escape("%()", stringBuffer, c2, this.pointer);
                }
            } else {
                stringBuffer.append(c);
            }
            this.state = TokenizerState.LITERAL_STATE;
        }
    }

    void escape(String string, StringBuffer stringBuffer) {
        if (this.pointer < this.patternLength) {
            char c = this.pattern.charAt(this.pointer++);
            this.escapeUtil.escape(string, stringBuffer, c, this.pointer);
        }
    }

    void optionEscape(String string, StringBuffer stringBuffer) {
        if (this.pointer < this.patternLength) {
            char c = this.pattern.charAt(this.pointer++);
            this.optionEscapeUtil.escape(string, stringBuffer, c, this.pointer);
        }
    }

    private void addValuedToken(int n, StringBuffer stringBuffer, List<Token> list) {
        if (stringBuffer.length() > 0) {
            list.add(new Token(n, stringBuffer.toString()));
            stringBuffer.setLength(0);
        }
    }

    static enum TokenizerState {
        LITERAL_STATE,
        FORMAT_MODIFIER_STATE,
        KEYWORD_STATE,
        OPTION_STATE,
        RIGHT_PARENTHESIS_STATE;

    }
}

