/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net;

import ch.qos.logback.core.AppenderBase;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;

public abstract class JMSAppenderBase<E>
extends AppenderBase<E> {
    protected String securityPrincipalName;
    protected String securityCredentials;
    protected String initialContextFactoryName;
    protected String urlPkgPrefixes;
    protected String providerURL;
    protected String userName;
    protected String password;

    protected Object lookup(Context context, String string) {
        try {
            return context.lookup(string);
        }
        catch (NameNotFoundException nameNotFoundException) {
            this.addError("Could not find name [" + string + "].");
            throw nameNotFoundException;
        }
    }

    public Context buildJNDIContext() {
        InitialContext initialContext = null;
        if (this.initialContextFactoryName != null) {
            Properties properties = this.buildEnvProperties();
            initialContext = new InitialContext(properties);
        } else {
            initialContext = new InitialContext();
        }
        return initialContext;
    }

    public Properties buildEnvProperties() {
        Properties properties = new Properties();
        properties.put("java.naming.factory.initial", this.initialContextFactoryName);
        if (this.providerURL != null) {
            properties.put("java.naming.provider.url", this.providerURL);
        } else {
            this.addWarn("You have set InitialContextFactoryName option but not the ProviderURL. This is likely to cause problems.");
        }
        if (this.urlPkgPrefixes != null) {
            properties.put("java.naming.factory.url.pkgs", this.urlPkgPrefixes);
        }
        if (this.securityPrincipalName != null) {
            properties.put("java.naming.security.principal", this.securityPrincipalName);
            if (this.securityCredentials != null) {
                properties.put("java.naming.security.credentials", this.securityCredentials);
            } else {
                this.addWarn("You have set SecurityPrincipalName option but not the SecurityCredentials. This is likely to cause problems.");
            }
        }
        return properties;
    }

    public String getInitialContextFactoryName() {
        return this.initialContextFactoryName;
    }

    public void setInitialContextFactoryName(String string) {
        this.initialContextFactoryName = string;
    }

    public String getProviderURL() {
        return this.providerURL;
    }

    public void setProviderURL(String string) {
        this.providerURL = string;
    }

    public String getURLPkgPrefixes() {
        return this.urlPkgPrefixes;
    }

    public void setURLPkgPrefixes(String string) {
        this.urlPkgPrefixes = string;
    }

    public String getSecurityCredentials() {
        return this.securityCredentials;
    }

    public void setSecurityCredentials(String string) {
        this.securityCredentials = string;
    }

    public String getSecurityPrincipalName() {
        return this.securityPrincipalName;
    }

    public void setSecurityPrincipalName(String string) {
        this.securityPrincipalName = string;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String string) {
        this.userName = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }
}

