/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.conditional;

import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.conditional.Condition;
import ch.qos.logback.core.joran.conditional.IfState;
import ch.qos.logback.core.joran.conditional.PropertyEvalScriptBuilder;
import ch.qos.logback.core.joran.event.SaxEvent;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.joran.spi.Interpreter;
import ch.qos.logback.core.util.EnvUtil;
import ch.qos.logback.core.util.OptionHelper;
import java.util.List;
import java.util.Stack;
import org.xml.sax.Attributes;

public class IfAction
extends Action {
    private static final String CONDITION_ATTR = "condition";
    public static final String MISSING_JANINO_MSG = "Could not find Janino library on the class path. Skipping conditional processing.";
    public static final String MISSING_JANINO_SEE = "See also http://logback.qos.ch/codes.html#ifJanino";
    Stack<IfState> stack = new Stack();

    @Override
    public void begin(InterpretationContext interpretationContext, String string, Attributes attributes) {
        IfState ifState = new IfState();
        boolean bl = this.stack.isEmpty();
        this.stack.push(ifState);
        if (!bl) {
            return;
        }
        interpretationContext.pushObject(this);
        if (!EnvUtil.isJaninoAvailable()) {
            this.addError(MISSING_JANINO_MSG);
            this.addError(MISSING_JANINO_SEE);
            return;
        }
        ifState.active = true;
        Condition condition = null;
        String string2 = attributes.getValue(CONDITION_ATTR);
        if (!OptionHelper.isEmpty(string2)) {
            string2 = OptionHelper.substVars(string2, interpretationContext, this.context);
            PropertyEvalScriptBuilder propertyEvalScriptBuilder = new PropertyEvalScriptBuilder(interpretationContext);
            propertyEvalScriptBuilder.setContext(this.context);
            try {
                condition = propertyEvalScriptBuilder.build(string2);
            }
            catch (Exception exception) {
                this.addError("Failed to parse condition [" + string2 + "]", exception);
            }
            if (condition != null) {
                ifState.boolResult = condition.evaluate();
            }
        }
    }

    @Override
    public void end(InterpretationContext interpretationContext, String string) {
        IfState ifState = this.stack.pop();
        if (!ifState.active) {
            return;
        }
        Object object = interpretationContext.peekObject();
        if (object == null) {
            throw new IllegalStateException("Unexpected null object on stack");
        }
        if (!(object instanceof IfAction)) {
            throw new IllegalStateException("Unexpected object of type [" + object.getClass() + "] on stack");
        }
        if (object != this) {
            throw new IllegalStateException("IfAction different then current one on stack");
        }
        interpretationContext.popObject();
        if (ifState.boolResult == null) {
            this.addError("Failed to determine \"if then else\" result");
            return;
        }
        Interpreter interpreter = interpretationContext.getJoranInterpreter();
        List<SaxEvent> list = ifState.thenSaxEventList;
        if (!ifState.boolResult.booleanValue()) {
            list = ifState.elseSaxEventList;
        }
        if (list != null) {
            interpreter.getEventPlayer().addEventsDynamically(list, 1);
        }
    }

    public void setThenSaxEventList(List<SaxEvent> list) {
        IfState ifState = (IfState)this.stack.firstElement();
        if (!ifState.active) {
            throw new IllegalStateException("setThenSaxEventList() invoked on inactive IfAction");
        }
        ifState.thenSaxEventList = list;
    }

    public void setElseSaxEventList(List<SaxEvent> list) {
        IfState ifState = (IfState)this.stack.firstElement();
        if (!ifState.active) {
            throw new IllegalStateException("setElseSaxEventList() invoked on inactive IfAction");
        }
        ifState.elseSaxEventList = list;
    }

    public boolean isActive() {
        if (this.stack == null) {
            return false;
        }
        if (this.stack.isEmpty()) {
            return false;
        }
        return this.stack.peek().active;
    }
}

