/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.action;

import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.action.ActionUtil;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.pattern.util.RegularEscapeUtil;
import ch.qos.logback.core.util.Loader;
import ch.qos.logback.core.util.OptionHelper;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.xml.sax.Attributes;

public class PropertyAction
extends Action {
    static final String RESOURCE_ATTRIBUTE = "resource";
    static String INVALID_ATTRIBUTES = "In <property> element, either the \"file\" attribute alone, or the \"resource\" element alone, or both the \"name\" and \"value\" attributes must be set.";

    @Override
    public void begin(InterpretationContext interpretationContext, String string, Attributes attributes) {
        if ("substitutionProperty".equals(string)) {
            this.addWarn("[substitutionProperty] element has been deprecated. Please use the [property] element instead.");
        }
        String string2 = attributes.getValue("name");
        String string3 = attributes.getValue("value");
        String string4 = attributes.getValue("scope");
        ActionUtil.Scope scope = ActionUtil.stringToScope(string4);
        if (this.checkFileAttributeSanity(attributes)) {
            String string5 = attributes.getValue("file");
            string5 = interpretationContext.subst(string5);
            try {
                FileInputStream fileInputStream = new FileInputStream(string5);
                this.loadAndSetProperties(interpretationContext, fileInputStream, scope);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.addError("Could not find properties file [" + string5 + "].");
            }
            catch (IOException iOException) {
                this.addError("Could not read properties file [" + string5 + "].", iOException);
            }
        } else if (this.checkResourceAttributeSanity(attributes)) {
            String string6 = attributes.getValue(RESOURCE_ATTRIBUTE);
            URL uRL = Loader.getResourceBySelfClassLoader(string6 = interpretationContext.subst(string6));
            if (uRL == null) {
                this.addError("Could not find resource [" + string6 + "].");
            } else {
                try {
                    InputStream inputStream = uRL.openStream();
                    this.loadAndSetProperties(interpretationContext, inputStream, scope);
                }
                catch (IOException iOException) {
                    this.addError("Could not read resource file [" + string6 + "].", iOException);
                }
            }
        } else if (this.checkValueNameAttributesSanity(attributes)) {
            string3 = RegularEscapeUtil.basicEscape(string3);
            string3 = string3.trim();
            string3 = interpretationContext.subst(string3);
            ActionUtil.setProperty(interpretationContext, string2, string3, scope);
        } else {
            this.addError(INVALID_ATTRIBUTES);
        }
    }

    void loadAndSetProperties(InterpretationContext interpretationContext, InputStream inputStream, ActionUtil.Scope scope) {
        Properties properties = new Properties();
        properties.load(inputStream);
        inputStream.close();
        ActionUtil.setProperties(interpretationContext, properties, scope);
    }

    boolean checkFileAttributeSanity(Attributes attributes) {
        String string = attributes.getValue("file");
        String string2 = attributes.getValue("name");
        String string3 = attributes.getValue("value");
        String string4 = attributes.getValue(RESOURCE_ATTRIBUTE);
        return !OptionHelper.isEmpty(string) && OptionHelper.isEmpty(string2) && OptionHelper.isEmpty(string3) && OptionHelper.isEmpty(string4);
    }

    boolean checkResourceAttributeSanity(Attributes attributes) {
        String string = attributes.getValue("file");
        String string2 = attributes.getValue("name");
        String string3 = attributes.getValue("value");
        String string4 = attributes.getValue(RESOURCE_ATTRIBUTE);
        return !OptionHelper.isEmpty(string4) && OptionHelper.isEmpty(string2) && OptionHelper.isEmpty(string3) && OptionHelper.isEmpty(string);
    }

    boolean checkValueNameAttributesSanity(Attributes attributes) {
        String string = attributes.getValue("file");
        String string2 = attributes.getValue("name");
        String string3 = attributes.getValue("value");
        String string4 = attributes.getValue(RESOURCE_ATTRIBUTE);
        return !OptionHelper.isEmpty(string2) && !OptionHelper.isEmpty(string3) && OptionHelper.isEmpty(string) && OptionHelper.isEmpty(string4);
    }

    @Override
    public void end(InterpretationContext interpretationContext, String string) {
    }

    public void finish(InterpretationContext interpretationContext) {
    }
}

