/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.action;

import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.action.ActionUtil;
import ch.qos.logback.core.joran.spi.ActionException;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.spi.PropertyDefiner;
import ch.qos.logback.core.util.OptionHelper;
import org.xml.sax.Attributes;

public class DefinePropertyAction
extends Action {
    String scopeStr;
    ActionUtil.Scope scope;
    String propertyName;
    PropertyDefiner definer;
    boolean inError;

    @Override
    public void begin(InterpretationContext interpretationContext, String string, Attributes attributes) {
        this.scopeStr = null;
        this.scope = null;
        this.propertyName = null;
        this.definer = null;
        this.inError = false;
        this.propertyName = attributes.getValue("name");
        this.scopeStr = attributes.getValue("scope");
        this.scope = ActionUtil.stringToScope(this.scopeStr);
        if (OptionHelper.isEmpty(this.propertyName)) {
            this.addError("Missing property name for property definer. Near [" + string + "] line " + this.getLineNumber(interpretationContext));
            this.inError = true;
            return;
        }
        String string2 = attributes.getValue("class");
        if (OptionHelper.isEmpty(string2)) {
            this.addError("Missing class name for property definer. Near [" + string + "] line " + this.getLineNumber(interpretationContext));
            this.inError = true;
            return;
        }
        try {
            this.addInfo("About to instantiate property definer of type [" + string2 + "]");
            this.definer = (PropertyDefiner)OptionHelper.instantiateByClassName(string2, PropertyDefiner.class, this.context);
            this.definer.setContext(this.context);
            if (this.definer instanceof LifeCycle) {
                ((LifeCycle)((Object)this.definer)).start();
            }
            interpretationContext.pushObject(this.definer);
        }
        catch (Exception exception) {
            this.inError = true;
            this.addError("Could not create an PropertyDefiner of type [" + string2 + "].", exception);
            throw new ActionException(exception);
        }
    }

    @Override
    public void end(InterpretationContext interpretationContext, String string) {
        if (this.inError) {
            return;
        }
        Object object = interpretationContext.peekObject();
        if (object != this.definer) {
            this.addWarn("The object at the of the stack is not the property definer for property named [" + this.propertyName + "] pushed earlier.");
        } else {
            this.addInfo("Popping property definer for property named [" + this.propertyName + "] from the object stack");
            interpretationContext.popObject();
            String string2 = this.definer.getPropertyValue();
            if (string2 != null) {
                ActionUtil.setProperty(interpretationContext, this.propertyName, string2, this.scope);
            }
        }
    }
}

