/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.encoder;

import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.encoder.EncoderBase;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public class LayoutWrappingEncoder<E>
extends EncoderBase<E> {
    protected Layout<E> layout;
    private Charset charset;
    private boolean immediateFlush = true;

    public void setImmediateFlush(boolean bl) {
        this.immediateFlush = bl;
    }

    public boolean isImmediateFlush() {
        return this.immediateFlush;
    }

    public Layout<E> getLayout() {
        return this.layout;
    }

    public void setLayout(Layout<E> layout) {
        this.layout = layout;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    @Override
    public void init(OutputStream outputStream) {
        super.init(outputStream);
        this.writeHeader();
    }

    void writeHeader() {
        if (this.layout != null && this.outputStream != null) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendIfNotNull(stringBuilder, this.layout.getFileHeader());
            this.appendIfNotNull(stringBuilder, this.layout.getPresentationHeader());
            if (stringBuilder.length() > 0) {
                stringBuilder.append(CoreConstants.LINE_SEPARATOR);
                this.outputStream.write(this.convertToBytes(stringBuilder.toString()));
                this.outputStream.flush();
            }
        }
    }

    @Override
    public void close() {
        this.writeFooter();
    }

    void writeFooter() {
        if (this.layout != null && this.outputStream != null) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendIfNotNull(stringBuilder, this.layout.getPresentationFooter());
            this.appendIfNotNull(stringBuilder, this.layout.getFileFooter());
            if (stringBuilder.length() > 0) {
                this.outputStream.write(this.convertToBytes(stringBuilder.toString()));
                this.outputStream.flush();
            }
        }
    }

    private byte[] convertToBytes(String string) {
        if (this.charset == null) {
            return string.getBytes();
        }
        try {
            return string.getBytes(this.charset.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException("An existing charset cannot possibly be unsupported.");
        }
    }

    @Override
    public void doEncode(E e) {
        String string = this.layout.doLayout(e);
        this.outputStream.write(this.convertToBytes(string));
        if (this.immediateFlush) {
            this.outputStream.flush();
        }
    }

    @Override
    public boolean isStarted() {
        return false;
    }

    @Override
    public void start() {
        this.started = true;
    }

    @Override
    public void stop() {
        this.started = false;
        if (this.outputStream != null) {
            try {
                this.outputStream.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void appendIfNotNull(StringBuilder stringBuilder, String string) {
        if (string != null) {
            stringBuilder.append(string);
        }
    }
}

