/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.encoder;

import ch.qos.logback.core.encoder.ByteArrayUtil;
import ch.qos.logback.core.encoder.NonClosableInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;

public class EventObjectInputStream<E>
extends InputStream {
    NonClosableInputStream ncis;
    List<E> buffer = new ArrayList();
    int index = 0;

    EventObjectInputStream(InputStream inputStream) {
        this.ncis = new NonClosableInputStream(inputStream);
    }

    @Override
    public int read() {
        throw new UnsupportedOperationException("Only the readEvent method is supported.");
    }

    @Override
    public int available() {
        return this.ncis.available();
    }

    public E readEvent() {
        E e = this.getFromBuffer();
        if (e != null) {
            return e;
        }
        this.internalReset();
        int n = this.readHeader();
        if (n == -1) {
            return null;
        }
        this.readPayload(n);
        this.readFooter(n);
        return this.getFromBuffer();
    }

    private void internalReset() {
        this.index = 0;
        this.buffer.clear();
    }

    E getFromBuffer() {
        if (this.index >= this.buffer.size()) {
            return null;
        }
        return this.buffer.get(this.index++);
    }

    int readHeader() {
        byte[] byArray = new byte[16];
        int n = this.ncis.read(byArray);
        if (n == -1) {
            return -1;
        }
        int n2 = 0;
        int n3 = ByteArrayUtil.readInt(byArray, n2);
        if (n3 != 1853421169) {
            throw new IllegalStateException("Does not look like data created by ObjectStreamEncoder");
        }
        int n4 = ByteArrayUtil.readInt(byArray, n2 += 4);
        int n5 = ByteArrayUtil.readInt(byArray, n2 += 4);
        int n6 = ByteArrayUtil.readInt(byArray, n2 += 4);
        if (n6 != (0x6E78F671 ^ n4)) {
            throw new IllegalStateException("Invalid checksum");
        }
        return n4;
    }

    E readEvents(ObjectInputStream objectInputStream) {
        Object object = null;
        try {
            object = objectInputStream.readObject();
            this.buffer.add(object);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        return (E)object;
    }

    void readFooter(int n) {
        byte[] byArray = new byte[8];
        this.ncis.read(byArray);
        int n2 = 0;
        int n3 = ByteArrayUtil.readInt(byArray, n2);
        if (n3 != 640373619) {
            throw new IllegalStateException("Looks like a corrupt stream");
        }
        int n4 = ByteArrayUtil.readInt(byArray, n2 += 4);
        if (n4 != (0x262B5373 ^ n)) {
            throw new IllegalStateException("Invalid checksum");
        }
    }

    void readPayload(int n) {
        ArrayList<E> arrayList = new ArrayList<E>(n);
        ObjectInputStream objectInputStream = new ObjectInputStream(this.ncis);
        for (int i = 0; i < n; ++i) {
            E e = this.readEvents(objectInputStream);
            arrayList.add(e);
        }
        objectInputStream.close();
    }

    @Override
    public void close() {
        this.ncis.realClose();
    }
}

