/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.db;

import ch.qos.logback.core.db.ConnectionSourceBase;
import java.sql.Connection;
import java.sql.DriverManager;

public class DriverManagerConnectionSource
extends ConnectionSourceBase {
    private String driverClass = null;
    private String url = null;

    @Override
    public void start() {
        try {
            if (this.driverClass != null) {
                Class.forName(this.driverClass);
                this.discoverConnectionProperties();
            } else {
                this.addError("WARNING: No JDBC driver specified for logback DriverManagerConnectionSource.");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.addError("Could not load JDBC driver class: " + this.driverClass, classNotFoundException);
        }
    }

    @Override
    public Connection getConnection() {
        if (this.getUser() == null) {
            return DriverManager.getConnection(this.url);
        }
        return DriverManager.getConnection(this.url, this.getUser(), this.getPassword());
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public void setDriverClass(String string) {
        this.driverClass = string;
    }
}

