/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core;

import ch.qos.logback.core.OutputStreamAppender;
import ch.qos.logback.core.recovery.ResilientFileOutputStream;
import ch.qos.logback.core.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

public class FileAppender<E>
extends OutputStreamAppender<E> {
    protected boolean append = true;
    protected String fileName = null;
    private boolean prudent = false;

    public void setFile(String string) {
        this.fileName = string == null ? string : string.trim();
    }

    public boolean isAppend() {
        return this.append;
    }

    public final String rawFileProperty() {
        return this.fileName;
    }

    public String getFile() {
        return this.fileName;
    }

    @Override
    public void start() {
        int n = 0;
        if (this.getFile() != null) {
            this.addInfo("File property is set to [" + this.fileName + "]");
            if (this.prudent && !this.isAppend()) {
                this.setAppend(true);
                this.addWarn("Setting \"Append\" property to true on account of \"Prudent\" mode");
            }
            try {
                this.openFile(this.getFile());
            }
            catch (IOException iOException) {
                ++n;
                this.addError("openFile(" + this.fileName + "," + this.append + ") call failed.", iOException);
            }
        } else {
            ++n;
            this.addError("\"File\" property not set for appender named [" + this.name + "].");
        }
        if (n == 0) {
            super.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openFile(String string) {
        this.lock.lock();
        try {
            File file = new File(string);
            boolean bl = FileUtil.createMissingParentDirectories(file);
            if (!bl) {
                this.addError("Failed to create parent directories for [" + file.getAbsolutePath() + "]");
            }
            ResilientFileOutputStream resilientFileOutputStream = new ResilientFileOutputStream(file, this.append);
            resilientFileOutputStream.setContext(this.context);
            this.setOutputStream(resilientFileOutputStream);
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isPrudent() {
        return this.prudent;
    }

    public void setPrudent(boolean bl) {
        this.prudent = bl;
    }

    public void setAppend(boolean bl) {
        this.append = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void safeWrite(E e) {
        ResilientFileOutputStream resilientFileOutputStream = (ResilientFileOutputStream)this.getOutputStream();
        FileChannel fileChannel = resilientFileOutputStream.getChannel();
        if (fileChannel == null) {
            return;
        }
        boolean bl = Thread.interrupted();
        FileLock fileLock = null;
        try {
            fileLock = fileChannel.lock();
            long l = fileChannel.position();
            long l2 = fileChannel.size();
            if (l2 != l) {
                fileChannel.position(l2);
            }
            super.writeOut(e);
        }
        catch (IOException iOException) {
            resilientFileOutputStream.postIOFailure(iOException);
        }
        finally {
            if (fileLock != null && fileLock.isValid()) {
                fileLock.release();
            }
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    protected void writeOut(E e) {
        if (this.prudent) {
            this.safeWrite(e);
        } else {
            super.writeOut(e);
        }
    }
}

