/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.spi.AppenderAttachable;
import ch.qos.logback.core.spi.AppenderAttachableImpl;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

public class AsyncAppenderBase<E>
extends UnsynchronizedAppenderBase<E>
implements AppenderAttachable<E> {
    AppenderAttachableImpl<E> aai = new AppenderAttachableImpl();
    BlockingQueue<E> blockingQueue;
    public static final int DEFAULT_QUEUE_SIZE = 256;
    int queueSize = 256;
    int appenderCount = 0;
    static final int UNDEFINED = -1;
    int discardingThreshold = -1;
    Worker worker = new Worker();
    public static final int DEFAULT_MAX_FLUSH_TIME = 1000;
    int maxFlushTime = 1000;

    protected boolean isDiscardable(E e) {
        return false;
    }

    protected void preprocess(E e) {
    }

    @Override
    public void start() {
        if (this.appenderCount == 0) {
            this.addError("No attached appenders found.");
            return;
        }
        if (this.queueSize < 1) {
            this.addError("Invalid queue size [" + this.queueSize + "]");
            return;
        }
        this.blockingQueue = new ArrayBlockingQueue(this.queueSize);
        if (this.discardingThreshold == -1) {
            this.discardingThreshold = this.queueSize / 5;
        }
        this.addInfo("Setting discardingThreshold to " + this.discardingThreshold);
        this.worker.setDaemon(true);
        this.worker.setName("AsyncAppender-Worker-" + this.getName());
        super.start();
        this.worker.start();
    }

    @Override
    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        super.stop();
        this.worker.interrupt();
        try {
            this.worker.join(this.maxFlushTime);
            if (this.worker.isAlive()) {
                this.addWarn("Max queue flush timeout (" + this.maxFlushTime + " ms) exceeded. Approximately " + this.blockingQueue.size() + " queued events were possibly discarded.");
            } else {
                this.addInfo("Queue flush finished successfully within timeout.");
            }
        }
        catch (InterruptedException interruptedException) {
            this.addError("Failed to join worker thread. " + this.blockingQueue.size() + " queued events may be discarded.", interruptedException);
        }
    }

    @Override
    protected void append(E e) {
        if (this.isQueueBelowDiscardingThreshold() && this.isDiscardable(e)) {
            return;
        }
        this.preprocess(e);
        this.put(e);
    }

    private boolean isQueueBelowDiscardingThreshold() {
        return this.blockingQueue.remainingCapacity() < this.discardingThreshold;
    }

    private void put(E e) {
        try {
            this.blockingQueue.put(e);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(int n) {
        this.queueSize = n;
    }

    public int getDiscardingThreshold() {
        return this.discardingThreshold;
    }

    public void setDiscardingThreshold(int n) {
        this.discardingThreshold = n;
    }

    public int getMaxFlushTime() {
        return this.maxFlushTime;
    }

    public void setMaxFlushTime(int n) {
        this.maxFlushTime = n;
    }

    public int getNumberOfElementsInQueue() {
        return this.blockingQueue.size();
    }

    public int getRemainingCapacity() {
        return this.blockingQueue.remainingCapacity();
    }

    @Override
    public void addAppender(Appender<E> appender) {
        if (this.appenderCount == 0) {
            ++this.appenderCount;
            this.addInfo("Attaching appender named [" + appender.getName() + "] to AsyncAppender.");
            this.aai.addAppender(appender);
        } else {
            this.addWarn("One and only one appender may be attached to AsyncAppender.");
            this.addWarn("Ignoring additional appender named [" + appender.getName() + "]");
        }
    }

    @Override
    public Iterator<Appender<E>> iteratorForAppenders() {
        return this.aai.iteratorForAppenders();
    }

    @Override
    public Appender<E> getAppender(String string) {
        return this.aai.getAppender(string);
    }

    @Override
    public boolean isAttached(Appender<E> appender) {
        return this.aai.isAttached(appender);
    }

    @Override
    public void detachAndStopAllAppenders() {
        this.aai.detachAndStopAllAppenders();
    }

    @Override
    public boolean detachAppender(Appender<E> appender) {
        return this.aai.detachAppender(appender);
    }

    @Override
    public boolean detachAppender(String string) {
        return this.aai.detachAppender(string);
    }

    class Worker
    extends Thread {
        Worker() {
        }

        @Override
        public void run() {
            AsyncAppenderBase asyncAppenderBase = AsyncAppenderBase.this;
            AppenderAttachableImpl appenderAttachableImpl = asyncAppenderBase.aai;
            while (asyncAppenderBase.isStarted()) {
                try {
                    Object e = asyncAppenderBase.blockingQueue.take();
                    appenderAttachableImpl.appendLoopOnAppenders(e);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                    break;
                }
            }
            AsyncAppenderBase.this.addInfo("Worker thread will flush remaining events before exiting. ");
            for (Object e : asyncAppenderBase.blockingQueue) {
                appenderAttachableImpl.appendLoopOnAppenders(e);
                asyncAppenderBase.blockingQueue.remove(e);
            }
            appenderAttachableImpl.detachAndStopAllAppenders();
        }
    }
}

