/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.util;

import ch.qos.logback.core.util.Loader;
import java.lang.reflect.Method;
import java.util.Iterator;

public class EnvUtil {
    static ClassLoader testServiceLoaderClassLoader = null;
    private static final Method serviceLoaderLoadMethod;
    private static final Method serviceLoaderIteratorMethod;

    public static boolean isGroovyAvailable() {
        ClassLoader classLoader = Loader.getClassLoaderOfClass(EnvUtil.class);
        try {
            Class<?> clazz = classLoader.loadClass("groovy.lang.Binding");
            return clazz != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static boolean isServiceLoaderAvailable() {
        return serviceLoaderLoadMethod != null && serviceLoaderIteratorMethod != null;
    }

    private static ClassLoader getServiceLoaderClassLoader() {
        return testServiceLoaderClassLoader == null ? Loader.getClassLoaderOfClass(EnvUtil.class) : testServiceLoaderClassLoader;
    }

    public static <T> T loadFromServiceLoader(Class<T> clazz) {
        if (EnvUtil.isServiceLoaderAvailable()) {
            Iterator iterator;
            Object object;
            try {
                object = serviceLoaderLoadMethod.invoke(null, clazz, EnvUtil.getServiceLoaderClassLoader());
            }
            catch (Exception exception) {
                throw new IllegalStateException("Cannot invoke java.util.ServiceLoader#load()", exception);
            }
            try {
                iterator = (Iterator)serviceLoaderIteratorMethod.invoke(object, new Object[0]);
            }
            catch (Exception exception) {
                throw new IllegalStateException("Cannot invoke java.util.ServiceLoader#iterator()", exception);
            }
            if (iterator.hasNext()) {
                return (T)iterator.next();
            }
        }
        return null;
    }

    static {
        Method method = null;
        Method method2 = null;
        try {
            Class<?> clazz = Class.forName("java.util.ServiceLoader");
            method = clazz.getMethod("load", Class.class, ClassLoader.class);
            method2 = clazz.getMethod("iterator", new Class[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        serviceLoaderLoadMethod = method;
        serviceLoaderIteratorMethod = method2;
    }
}

