/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.util;

import ch.qos.logback.classic.BasicConfigurator;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.gaffer.GafferUtil;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.spi.Configurator;
import ch.qos.logback.classic.util.EnvUtil;
import ch.qos.logback.classic.util.StatusListenerConfigHelper;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.LogbackException;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.status.WarnStatus;
import ch.qos.logback.core.util.Loader;
import ch.qos.logback.core.util.OptionHelper;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;

public class ContextInitializer {
    public static final String GROOVY_AUTOCONFIG_FILE = "logback.groovy";
    public static final String AUTOCONFIG_FILE = "logback.xml";
    public static final String TEST_AUTOCONFIG_FILE = "logback-test.xml";
    public static final String CONFIG_FILE_PROPERTY = "logback.configurationFile";
    public static final String STATUS_LISTENER_CLASS = "logback.statusListenerClass";
    public static final String SYSOUT = "SYSOUT";
    final LoggerContext loggerContext;

    public ContextInitializer(LoggerContext loggerContext) {
        this.loggerContext = loggerContext;
    }

    public void configureByResource(URL uRL) {
        if (uRL == null) {
            throw new IllegalArgumentException("URL argument cannot be null");
        }
        String string = uRL.toString();
        if (string.endsWith("groovy")) {
            if (EnvUtil.isGroovyAvailable()) {
                GafferUtil.runGafferConfiguratorOn(this.loggerContext, (Object)this, uRL);
            } else {
                StatusManager statusManager = this.loggerContext.getStatusManager();
                statusManager.add((Status)new ErrorStatus("Groovy classes are not available on the class path. ABORTING INITIALIZATION.", (Object)this.loggerContext));
            }
        } else if (string.endsWith("xml")) {
            JoranConfigurator joranConfigurator = new JoranConfigurator();
            joranConfigurator.setContext((Context)this.loggerContext);
            joranConfigurator.doConfigure(uRL);
        } else {
            throw new LogbackException("Unexpected filename extension of file [" + uRL.toString() + "]. Should be either .groovy or .xml");
        }
    }

    void joranConfigureByResource(URL uRL) {
        JoranConfigurator joranConfigurator = new JoranConfigurator();
        joranConfigurator.setContext((Context)this.loggerContext);
        joranConfigurator.doConfigure(uRL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL findConfigFileURLFromSystemProperties(ClassLoader classLoader, boolean bl) {
        String string = OptionHelper.getSystemProperty((String)CONFIG_FILE_PROPERTY);
        if (string != null) {
            URL uRL = null;
            try {
                URL uRL2 = uRL = new URL(string);
                return uRL2;
            }
            catch (MalformedURLException malformedURLException) {
                uRL = Loader.getResource((String)string, (ClassLoader)classLoader);
                if (uRL != null) {
                    URL uRL3 = uRL;
                    return uRL3;
                }
                File file = new File(string);
                if (file.exists() && file.isFile()) {
                    try {
                        URL uRL4 = uRL = file.toURI().toURL();
                        return uRL4;
                    }
                    catch (MalformedURLException malformedURLException2) {}
                }
            }
            finally {
                if (bl) {
                    this.statusOnResourceSearch(string, classLoader, uRL);
                }
            }
        }
        return null;
    }

    public URL findURLOfDefaultConfigurationFile(boolean bl) {
        ClassLoader classLoader = Loader.getClassLoaderOfObject((Object)this);
        URL uRL = this.findConfigFileURLFromSystemProperties(classLoader, bl);
        if (uRL != null) {
            return uRL;
        }
        uRL = this.getResource(GROOVY_AUTOCONFIG_FILE, classLoader, bl);
        if (uRL != null) {
            return uRL;
        }
        uRL = this.getResource(TEST_AUTOCONFIG_FILE, classLoader, bl);
        if (uRL != null) {
            return uRL;
        }
        return this.getResource(AUTOCONFIG_FILE, classLoader, bl);
    }

    private URL getResource(String string, ClassLoader classLoader, boolean bl) {
        URL uRL = Loader.getResource((String)string, (ClassLoader)classLoader);
        if (bl) {
            this.statusOnResourceSearch(string, classLoader, uRL);
        }
        return uRL;
    }

    public void autoConfig() {
        StatusListenerConfigHelper.installIfAsked(this.loggerContext);
        URL uRL = this.findURLOfDefaultConfigurationFile(true);
        if (uRL != null) {
            this.configureByResource(uRL);
        } else {
            Configurator configurator = EnvUtil.loadFromServiceLoader(Configurator.class);
            if (configurator != null) {
                try {
                    configurator.setContext((Context)this.loggerContext);
                    configurator.configure(this.loggerContext);
                }
                catch (Exception exception) {
                    throw new LogbackException(String.format("Failed to initialize Configurator: %s using ServiceLoader", configurator != null ? configurator.getClass().getCanonicalName() : "null"), (Throwable)exception);
                }
            } else {
                BasicConfigurator.configure(this.loggerContext);
            }
        }
    }

    private void multiplicityWarning(String string, ClassLoader classLoader) {
        Set set = null;
        StatusManager statusManager = this.loggerContext.getStatusManager();
        try {
            set = Loader.getResourceOccurrenceCount((String)string, (ClassLoader)classLoader);
        }
        catch (IOException iOException) {
            statusManager.add((Status)new ErrorStatus("Failed to get url list for resource [" + string + "]", (Object)this.loggerContext, (Throwable)iOException));
        }
        if (set != null && set.size() > 1) {
            statusManager.add((Status)new WarnStatus("Resource [" + string + "] occurs multiple times on the classpath.", (Object)this.loggerContext));
            for (URL uRL : set) {
                statusManager.add((Status)new WarnStatus("Resource [" + string + "] occurs at [" + uRL.toString() + "]", (Object)this.loggerContext));
            }
        }
    }

    private void statusOnResourceSearch(String string, ClassLoader classLoader, URL uRL) {
        StatusManager statusManager = this.loggerContext.getStatusManager();
        if (uRL == null) {
            statusManager.add((Status)new InfoStatus("Could NOT find resource [" + string + "]", (Object)this.loggerContext));
        } else {
            statusManager.add((Status)new InfoStatus("Found resource [" + string + "] at [" + uRL.toString() + "]", (Object)this.loggerContext));
            this.multiplicityWarning(string, classLoader);
        }
    }
}

