/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.selector;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.selector.ContextSelector;
import ch.qos.logback.classic.util.ContextInitializer;
import ch.qos.logback.classic.util.JNDIUtil;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.status.StatusUtil;
import ch.qos.logback.core.status.WarnStatus;
import ch.qos.logback.core.util.Loader;
import ch.qos.logback.core.util.StatusPrinter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;

public class ContextJNDISelector
implements ContextSelector {
    private final Map<String, LoggerContext> synchronizedContextMap = Collections.synchronizedMap(new HashMap());
    private final LoggerContext defaultContext;
    private static final ThreadLocal<LoggerContext> threadLocal = new ThreadLocal();

    public ContextJNDISelector(LoggerContext loggerContext) {
        this.defaultContext = loggerContext;
    }

    @Override
    public LoggerContext getDefaultLoggerContext() {
        return this.defaultContext;
    }

    @Override
    public LoggerContext detachLoggerContext(String string) {
        return this.synchronizedContextMap.remove(string);
    }

    @Override
    public LoggerContext getLoggerContext() {
        String string = null;
        javax.naming.Context context = null;
        LoggerContext loggerContext = threadLocal.get();
        if (loggerContext != null) {
            return loggerContext;
        }
        try {
            context = JNDIUtil.getInitialContext();
            string = JNDIUtil.lookup(context, "java:comp/env/logback/context-name");
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        if (string == null) {
            return this.defaultContext;
        }
        LoggerContext loggerContext2 = this.synchronizedContextMap.get(string);
        if (loggerContext2 == null) {
            loggerContext2 = new LoggerContext();
            loggerContext2.setName(string);
            this.synchronizedContextMap.put(string, loggerContext2);
            URL uRL = this.findConfigFileURL(context, loggerContext2);
            if (uRL != null) {
                this.configureLoggerContextByURL(loggerContext2, uRL);
            } else {
                try {
                    new ContextInitializer(loggerContext2).autoConfig();
                }
                catch (JoranException joranException) {
                    // empty catch block
                }
            }
            if (!StatusUtil.contextHasStatusListener((Context)loggerContext2)) {
                StatusPrinter.printInCaseOfErrorsOrWarnings((Context)loggerContext2);
            }
        }
        return loggerContext2;
    }

    private String conventionalConfigFileName(String string) {
        return "logback-" + string + ".xml";
    }

    private URL findConfigFileURL(javax.naming.Context context, LoggerContext loggerContext) {
        StatusManager statusManager = loggerContext.getStatusManager();
        String string = JNDIUtil.lookup(context, "java:comp/env/logback/configuration-resource");
        if (string != null) {
            statusManager.add((Status)new InfoStatus("Searching for [" + string + "]", (Object)this));
            URL uRL = this.urlByResourceName(statusManager, string);
            if (uRL == null) {
                String string2 = "The jndi resource [" + string + "] for context [" + loggerContext.getName() + "] does not lead to a valid file";
                statusManager.add((Status)new WarnStatus(string2, (Object)this));
            }
            return uRL;
        }
        String string3 = this.conventionalConfigFileName(loggerContext.getName());
        return this.urlByResourceName(statusManager, string3);
    }

    private URL urlByResourceName(StatusManager statusManager, String string) {
        statusManager.add((Status)new InfoStatus("Searching for [" + string + "]", (Object)this));
        URL uRL = Loader.getResource((String)string, (ClassLoader)Loader.getTCL());
        if (uRL != null) {
            return uRL;
        }
        return Loader.getResourceBySelfClassLoader((String)string);
    }

    private void configureLoggerContextByURL(LoggerContext loggerContext, URL uRL) {
        try {
            JoranConfigurator joranConfigurator = new JoranConfigurator();
            loggerContext.reset();
            joranConfigurator.setContext((Context)loggerContext);
            joranConfigurator.doConfigure(uRL);
        }
        catch (JoranException joranException) {
            // empty catch block
        }
        StatusPrinter.printInCaseOfErrorsOrWarnings((Context)loggerContext);
    }

    @Override
    public List<String> getContextNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.synchronizedContextMap.keySet());
        return arrayList;
    }

    @Override
    public LoggerContext getLoggerContext(String string) {
        return this.synchronizedContextMap.get(string);
    }

    public int getCount() {
        return this.synchronizedContextMap.size();
    }

    public void setLocalContext(LoggerContext loggerContext) {
        threadLocal.set(loggerContext);
    }

    public void removeLocalContext() {
        threadLocal.remove();
    }
}

