/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.pattern.ClassicConverter;
import ch.qos.logback.classic.spi.CallerData;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.boolex.EvaluationException;
import ch.qos.logback.core.boolex.EventEvaluator;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.Status;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class CallerDataConverter
extends ClassicConverter {
    public static final String DEFAULT_CALLER_LINE_PREFIX = "Caller+";
    public static final String DEFAULT_RANGE_DELIMITER = "..";
    private int depthStart = 0;
    private int depthEnd = 5;
    List<EventEvaluator<ILoggingEvent>> evaluatorList = null;
    final int MAX_ERROR_COUNT = 4;
    int errorCount = 0;

    public void start() {
        Object object;
        String string = this.getFirstOption();
        if (string == null) {
            return;
        }
        try {
            if (this.isRange(string)) {
                object = this.splitRange(string);
                if (((String[])object).length == 2) {
                    this.depthStart = Integer.parseInt(object[0]);
                    this.depthEnd = Integer.parseInt((String)object[1]);
                    this.checkRange();
                } else {
                    this.addError("Failed to parse depth option as range [" + string + "]");
                }
            } else {
                this.depthEnd = Integer.parseInt(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.addError("Failed to parse depth option [" + string + "]", numberFormatException);
        }
        object = this.getOptionList();
        if (object != null && object.size() > 1) {
            int n = object.size();
            for (int i = 1; i < n; ++i) {
                Map map;
                EventEvaluator eventEvaluator;
                String string2 = (String)object.get(i);
                Context context = this.getContext();
                if (context == null || (eventEvaluator = (EventEvaluator)(map = (Map)context.getObject("EVALUATOR_MAP")).get(string2)) == null) continue;
                this.addEvaluator((EventEvaluator<ILoggingEvent>)eventEvaluator);
            }
        }
    }

    private boolean isRange(String string) {
        return string.contains(this.getDefaultRangeDelimiter());
    }

    private String[] splitRange(String string) {
        return string.split(Pattern.quote(this.getDefaultRangeDelimiter()), 2);
    }

    private void checkRange() {
        if (this.depthStart < 0 || this.depthEnd < 0) {
            this.addError("Invalid depthStart/depthEnd range [" + this.depthStart + ", " + this.depthEnd + "] (negative values are not allowed)");
        } else if (this.depthStart >= this.depthEnd) {
            this.addError("Invalid depthEnd range [" + this.depthStart + ", " + this.depthEnd + "] (start greater or equal to end)");
        }
    }

    private void addEvaluator(EventEvaluator<ILoggingEvent> eventEvaluator) {
        if (this.evaluatorList == null) {
            this.evaluatorList = new ArrayList<EventEvaluator<ILoggingEvent>>();
        }
        this.evaluatorList.add(eventEvaluator);
    }

    public String convert(ILoggingEvent iLoggingEvent) {
        StackTraceElement[] stackTraceElementArray;
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.evaluatorList != null) {
            boolean bl = false;
            for (n = 0; n < this.evaluatorList.size(); ++n) {
                EventEvaluator<ILoggingEvent> eventEvaluator = this.evaluatorList.get(n);
                try {
                    if (!eventEvaluator.evaluate((Object)iLoggingEvent)) continue;
                    bl = true;
                    break;
                }
                catch (EvaluationException evaluationException) {
                    ++this.errorCount;
                    if (this.errorCount < 4) {
                        this.addError("Exception thrown for evaluator named [" + eventEvaluator.getName() + "]", evaluationException);
                        continue;
                    }
                    if (this.errorCount != 4) continue;
                    ErrorStatus errorStatus = new ErrorStatus("Exception thrown for evaluator named [" + eventEvaluator.getName() + "].", (Object)this, (Throwable)evaluationException);
                    errorStatus.add((Status)new ErrorStatus("This was the last warning about this evaluator's errors.We don't want the StatusManager to get flooded.", (Object)this));
                    this.addStatus((Status)errorStatus);
                }
            }
            if (!bl) {
                return "";
            }
        }
        if ((stackTraceElementArray = iLoggingEvent.getCallerData()) != null && stackTraceElementArray.length > this.depthStart) {
            n = this.depthEnd < stackTraceElementArray.length ? this.depthEnd : stackTraceElementArray.length;
            for (int i = this.depthStart; i < n; ++i) {
                stringBuilder.append(this.getCallerLinePrefix());
                stringBuilder.append(i);
                stringBuilder.append("\t at ");
                stringBuilder.append(stackTraceElementArray[i]);
                stringBuilder.append(CoreConstants.LINE_SEPARATOR);
            }
            return stringBuilder.toString();
        }
        return CallerData.CALLER_DATA_NA;
    }

    protected String getCallerLinePrefix() {
        return DEFAULT_CALLER_LINE_PREFIX;
    }

    protected String getDefaultRangeDelimiter() {
        return DEFAULT_RANGE_DELIMITER;
    }
}

