/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.net.SocketNode;
import ch.qos.logback.core.Context;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.net.ServerSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSocketServer
extends Thread {
    Logger logger = LoggerFactory.getLogger(SimpleSocketServer.class);
    private final int port;
    private final LoggerContext lc;
    private boolean closed = false;
    private ServerSocket serverSocket;
    private List<SocketNode> socketNodeList = new ArrayList<SocketNode>();
    private CountDownLatch latch;

    public static void main(String[] stringArray) {
        SimpleSocketServer.doMain(SimpleSocketServer.class, stringArray);
    }

    protected static void doMain(Class<? extends SimpleSocketServer> clazz, String[] stringArray) {
        int n = -1;
        if (stringArray.length == 2) {
            n = SimpleSocketServer.parsePortNumber(stringArray[0]);
        } else {
            SimpleSocketServer.usage("Wrong number of arguments.");
        }
        String string = stringArray[1];
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        SimpleSocketServer.configureLC(loggerContext, string);
        SimpleSocketServer simpleSocketServer = new SimpleSocketServer(loggerContext, n);
        simpleSocketServer.start();
    }

    public SimpleSocketServer(LoggerContext loggerContext, int n) {
        this.lc = loggerContext;
        this.port = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String string = Thread.currentThread().getName();
        try {
            String string2 = this.getServerThreadName();
            Thread.currentThread().setName(string2);
            this.logger.info("Listening on port " + this.port);
            this.serverSocket = this.getServerSocketFactory().createServerSocket(this.port);
            while (!this.closed) {
                this.logger.info("Waiting to accept a new client.");
                this.signalAlmostReadiness();
                Socket socket = this.serverSocket.accept();
                this.logger.info("Connected to client at " + socket.getInetAddress());
                this.logger.info("Starting new socket node.");
                SocketNode socketNode = new SocketNode(this, socket, this.lc);
                Object object = this.socketNodeList;
                synchronized (object) {
                    this.socketNodeList.add(socketNode);
                }
                object = this.getClientThreadName(socket);
                new Thread((Runnable)socketNode, (String)object).start();
            }
        }
        catch (Exception exception) {
            if (this.closed) {
                this.logger.info("Exception in run method for a closed server. This is normal.");
            } else {
                this.logger.error("Unexpected failure in run method", (Throwable)exception);
            }
        }
        finally {
            Thread.currentThread().setName(string);
        }
    }

    protected String getServerThreadName() {
        return String.format("Logback %s (port %d)", this.getClass().getSimpleName(), this.port);
    }

    protected String getClientThreadName(Socket socket) {
        return String.format("Logback SocketNode (client: %s)", socket.getRemoteSocketAddress());
    }

    protected ServerSocketFactory getServerSocketFactory() {
        return ServerSocketFactory.getDefault();
    }

    void signalAlmostReadiness() {
        if (this.latch != null && this.latch.getCount() != 0L) {
            this.latch.countDown();
        }
    }

    void setLatch(CountDownLatch countDownLatch) {
        this.latch = countDownLatch;
    }

    public CountDownLatch getLatch() {
        return this.latch;
    }

    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.closed = true;
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                this.logger.error("Failed to close serverSocket", (Throwable)iOException);
            }
            finally {
                this.serverSocket = null;
            }
        }
        this.logger.info("closing this server");
        List<SocketNode> list = this.socketNodeList;
        synchronized (list) {
            for (SocketNode socketNode : this.socketNodeList) {
                socketNode.close();
            }
        }
        if (this.socketNodeList.size() != 0) {
            this.logger.warn("Was expecting a 0-sized socketNodeList after server shutdown");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void socketNodeClosing(SocketNode socketNode) {
        this.logger.debug("Removing {}", (Object)socketNode);
        List<SocketNode> list = this.socketNodeList;
        synchronized (list) {
            this.socketNodeList.remove(socketNode);
        }
    }

    static void usage(String string) {
        System.err.println(string);
        System.err.println("Usage: java " + SimpleSocketServer.class.getName() + " port configFile");
        System.exit(1);
    }

    static int parsePortNumber(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            SimpleSocketServer.usage("Could not interpret port number [" + string + "].");
            return -1;
        }
    }

    public static void configureLC(LoggerContext loggerContext, String string) {
        JoranConfigurator joranConfigurator = new JoranConfigurator();
        loggerContext.reset();
        joranConfigurator.setContext((Context)loggerContext);
        joranConfigurator.doConfigure(string);
    }
}

