/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.util.ContextInitializer;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import org.slf4j.LoggerFactory;

public class JMSTopicSink
implements MessageListener {
    private Logger logger = (Logger)LoggerFactory.getLogger(JMSTopicSink.class);

    public static void main(String[] stringArray) {
        String string;
        if (stringArray.length < 2) {
            JMSTopicSink.usage("Wrong number of arguments.");
        }
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        String string4 = null;
        String string5 = null;
        if (stringArray.length == 4) {
            string4 = stringArray[2];
            string5 = stringArray[3];
        }
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        new ContextInitializer(loggerContext).autoConfig();
        new JMSTopicSink(string2, string3, string4, string5);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("Type \"exit\" to quit JMSTopicSink.");
        while (!(string = bufferedReader.readLine()).equalsIgnoreCase("exit")) {
        }
        System.out.println("Exiting. Kill the application if it does not exit due to daemon threads.");
    }

    public JMSTopicSink(String string, String string2, String string3, String string4) {
        try {
            Properties properties = new Properties();
            properties.put("java.naming.factory.initial", "org.apache.activemq.jndi.ActiveMQInitialContextFactory");
            properties.put("java.naming.provider.url", "tcp://localhost:61616");
            InitialContext initialContext = new InitialContext(properties);
            TopicConnectionFactory topicConnectionFactory = (TopicConnectionFactory)this.lookup(initialContext, string);
            System.out.println("Topic Cnx Factory found");
            Topic topic = (Topic)initialContext.lookup(string2);
            System.out.println("Topic found: " + topic.getTopicName());
            TopicConnection topicConnection = topicConnectionFactory.createTopicConnection(string3, string4);
            System.out.println("Topic Connection created");
            TopicSession topicSession = topicConnection.createTopicSession(false, 1);
            TopicSubscriber topicSubscriber = topicSession.createSubscriber(topic);
            topicSubscriber.setMessageListener((MessageListener)this);
            topicConnection.start();
            System.out.println("Topic Connection started");
        }
        catch (Exception exception) {
            this.logger.error("Could not read JMS message.", exception);
        }
    }

    public void onMessage(Message message) {
        try {
            if (message instanceof ObjectMessage) {
                ObjectMessage objectMessage = (ObjectMessage)message;
                ILoggingEvent iLoggingEvent = (ILoggingEvent)((Object)objectMessage.getObject());
                Logger logger = (Logger)LoggerFactory.getLogger((String)iLoggingEvent.getLoggerName());
                logger.callAppenders(iLoggingEvent);
            } else {
                this.logger.warn("Received message is of type " + message.getJMSType() + ", was expecting ObjectMessage.");
            }
        }
        catch (JMSException jMSException) {
            this.logger.error("Exception thrown while processing incoming message.", jMSException);
        }
    }

    protected Object lookup(Context context, String string) {
        try {
            return context.lookup(string);
        }
        catch (NameNotFoundException nameNotFoundException) {
            this.logger.error("Could not find name [" + string + "].");
            throw nameNotFoundException;
        }
    }

    static void usage(String string) {
        System.err.println(string);
        System.err.println("Usage: java " + JMSTopicSink.class.getName() + " TopicConnectionFactoryBindingName TopicBindingName Username Password");
        System.exit(1);
    }
}

