/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net;

import ch.qos.logback.classic.net.LoggingEventPreSerializationTransformer;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.net.JMSAppenderBase;
import ch.qos.logback.core.spi.PreSerializationTransformer;
import java.io.Serializable;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.Context;

public class JMSTopicAppender
extends JMSAppenderBase<ILoggingEvent> {
    static int SUCCESSIVE_FAILURE_LIMIT = 3;
    String topicBindingName;
    String tcfBindingName;
    TopicConnection topicConnection;
    TopicSession topicSession;
    TopicPublisher topicPublisher;
    int successiveFailureCount = 0;
    private PreSerializationTransformer<ILoggingEvent> pst = new LoggingEventPreSerializationTransformer();

    public void setTopicConnectionFactoryBindingName(String string) {
        this.tcfBindingName = string;
    }

    public String getTopicConnectionFactoryBindingName() {
        return this.tcfBindingName;
    }

    public void setTopicBindingName(String string) {
        this.topicBindingName = string;
    }

    public String getTopicBindingName() {
        return this.topicBindingName;
    }

    public void start() {
        try {
            Context context = this.buildJNDIContext();
            TopicConnectionFactory topicConnectionFactory = (TopicConnectionFactory)this.lookup(context, this.tcfBindingName);
            this.topicConnection = this.userName != null ? topicConnectionFactory.createTopicConnection(this.userName, this.password) : topicConnectionFactory.createTopicConnection();
            this.topicSession = this.topicConnection.createTopicSession(false, 1);
            Topic topic = (Topic)this.lookup(context, this.topicBindingName);
            this.topicPublisher = this.topicSession.createPublisher(topic);
            this.topicConnection.start();
            context.close();
        }
        catch (Exception exception) {
            this.addError("Error while activating options for appender named [" + this.name + "].", exception);
        }
        if (this.topicConnection != null && this.topicSession != null && this.topicPublisher != null) {
            super.start();
        }
    }

    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        this.started = false;
        try {
            if (this.topicSession != null) {
                this.topicSession.close();
            }
            if (this.topicConnection != null) {
                this.topicConnection.close();
            }
        }
        catch (Exception exception) {
            this.addError("Error while closing JMSAppender [" + this.name + "].", exception);
        }
        this.topicPublisher = null;
        this.topicSession = null;
        this.topicConnection = null;
    }

    public void append(ILoggingEvent iLoggingEvent) {
        if (!this.isStarted()) {
            return;
        }
        try {
            ObjectMessage objectMessage = this.topicSession.createObjectMessage();
            Serializable serializable = this.pst.transform((Object)iLoggingEvent);
            objectMessage.setObject(serializable);
            this.topicPublisher.publish((Message)objectMessage);
            this.successiveFailureCount = 0;
        }
        catch (Exception exception) {
            ++this.successiveFailureCount;
            if (this.successiveFailureCount > SUCCESSIVE_FAILURE_LIMIT) {
                this.stop();
            }
            this.addError("Could not publish message in JMSTopicAppender [" + this.name + "].", exception);
        }
    }

    protected TopicConnection getTopicConnection() {
        return this.topicConnection;
    }

    protected TopicSession getTopicSession() {
        return this.topicSession;
    }

    protected TopicPublisher getTopicPublisher() {
        return this.topicPublisher;
    }
}

