/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net;

import ch.qos.logback.classic.net.LoggingEventPreSerializationTransformer;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.net.JMSAppenderBase;
import ch.qos.logback.core.spi.PreSerializationTransformer;
import java.io.Serializable;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.naming.Context;

public class JMSQueueAppender
extends JMSAppenderBase<ILoggingEvent> {
    static int SUCCESSIVE_FAILURE_LIMIT = 3;
    String queueBindingName;
    String qcfBindingName;
    QueueConnection queueConnection;
    QueueSession queueSession;
    QueueSender queueSender;
    int successiveFailureCount = 0;
    private PreSerializationTransformer<ILoggingEvent> pst = new LoggingEventPreSerializationTransformer();

    public void setQueueConnectionFactoryBindingName(String string) {
        this.qcfBindingName = string;
    }

    public String getQueueConnectionFactoryBindingName() {
        return this.qcfBindingName;
    }

    public void setQueueBindingName(String string) {
        this.queueBindingName = string;
    }

    public String getQueueBindingName() {
        return this.queueBindingName;
    }

    public void start() {
        try {
            Context context = this.buildJNDIContext();
            QueueConnectionFactory queueConnectionFactory = (QueueConnectionFactory)this.lookup(context, this.qcfBindingName);
            this.queueConnection = this.userName != null ? queueConnectionFactory.createQueueConnection(this.userName, this.password) : queueConnectionFactory.createQueueConnection();
            this.queueSession = this.queueConnection.createQueueSession(false, 1);
            Queue queue = (Queue)this.lookup(context, this.queueBindingName);
            this.queueSender = this.queueSession.createSender(queue);
            this.queueConnection.start();
            context.close();
        }
        catch (Exception exception) {
            this.addError("Error while activating options for appender named [" + this.name + "].", exception);
        }
        if (this.queueConnection != null && this.queueSession != null && this.queueSender != null) {
            super.start();
        }
    }

    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        this.started = false;
        try {
            if (this.queueSession != null) {
                this.queueSession.close();
            }
            if (this.queueConnection != null) {
                this.queueConnection.close();
            }
        }
        catch (Exception exception) {
            this.addError("Error while closing JMSAppender [" + this.name + "].", exception);
        }
        this.queueSender = null;
        this.queueSession = null;
        this.queueConnection = null;
    }

    public void append(ILoggingEvent iLoggingEvent) {
        if (!this.isStarted()) {
            return;
        }
        try {
            ObjectMessage objectMessage = this.queueSession.createObjectMessage();
            Serializable serializable = this.pst.transform((Object)iLoggingEvent);
            objectMessage.setObject(serializable);
            this.queueSender.send((Message)objectMessage);
            this.successiveFailureCount = 0;
        }
        catch (Exception exception) {
            ++this.successiveFailureCount;
            if (this.successiveFailureCount > SUCCESSIVE_FAILURE_LIMIT) {
                this.stop();
            }
            this.addError("Could not send message in JMSQueueAppender [" + this.name + "].", exception);
        }
    }

    protected QueueConnection getQueueConnection() {
        return this.queueConnection;
    }

    protected QueueSession getQueueSession() {
        return this.queueSession;
    }

    protected QueueSender getQueueSender() {
        return this.queueSender;
    }
}

