/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.jul;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.jul.JULHelper;
import ch.qos.logback.classic.spi.LoggerContextListener;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.LifeCycle;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.LogManager;

public class LevelChangePropagator
extends ContextAwareBase
implements LoggerContextListener,
LifeCycle {
    private Set julLoggerSet = new HashSet();
    boolean isStarted = false;
    boolean resetJUL = false;

    public void setResetJUL(boolean bl) {
        this.resetJUL = bl;
    }

    @Override
    public boolean isResetResistant() {
        return false;
    }

    @Override
    public void onStart(LoggerContext loggerContext) {
    }

    @Override
    public void onReset(LoggerContext loggerContext) {
    }

    @Override
    public void onStop(LoggerContext loggerContext) {
    }

    @Override
    public void onLevelChange(Logger logger, Level level) {
        this.propagate(logger, level);
    }

    private void propagate(Logger logger, Level level) {
        this.addInfo("Propagating " + level + " level on " + logger + " onto the JUL framework");
        java.util.logging.Logger logger2 = JULHelper.asJULLogger(logger);
        this.julLoggerSet.add(logger2);
        java.util.logging.Level level2 = JULHelper.asJULLevel(level);
        logger2.setLevel(level2);
    }

    public void resetJULLevels() {
        LogManager logManager = LogManager.getLogManager();
        Enumeration<String> enumeration = logManager.getLoggerNames();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            java.util.logging.Logger logger = logManager.getLogger(string);
            if (!JULHelper.isRegularNonRootLogger(logger) || logger.getLevel() == null) continue;
            this.addInfo("Setting level of jul logger [" + string + "] to null");
            logger.setLevel(null);
        }
    }

    private void propagateExistingLoggerLevels() {
        LoggerContext loggerContext = (LoggerContext)this.context;
        List<Logger> list = loggerContext.getLoggerList();
        for (Logger logger : list) {
            if (logger.getLevel() == null) continue;
            this.propagate(logger, logger.getLevel());
        }
    }

    public void start() {
        if (this.resetJUL) {
            this.resetJULLevels();
        }
        this.propagateExistingLoggerLevels();
        this.isStarted = true;
    }

    public void stop() {
        this.isStarted = false;
    }

    public boolean isStarted() {
        return this.isStarted;
    }
}

