/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.jul;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;

public class JULHelper {
    public static final boolean isRegularNonRootLogger(java.util.logging.Logger logger) {
        if (logger == null) {
            return false;
        }
        return !logger.getName().equals("");
    }

    public static final boolean isRoot(java.util.logging.Logger logger) {
        if (logger == null) {
            return false;
        }
        return logger.getName().equals("");
    }

    public static java.util.logging.Level asJULLevel(Level level) {
        if (level == null) {
            throw new IllegalArgumentException("Unexpected level [null]");
        }
        switch (level.levelInt) {
            case -2147483648: {
                return java.util.logging.Level.ALL;
            }
            case 5000: {
                return java.util.logging.Level.FINEST;
            }
            case 10000: {
                return java.util.logging.Level.FINE;
            }
            case 20000: {
                return java.util.logging.Level.INFO;
            }
            case 30000: {
                return java.util.logging.Level.WARNING;
            }
            case 40000: {
                return java.util.logging.Level.SEVERE;
            }
            case 0x7FFFFFFF: {
                return java.util.logging.Level.OFF;
            }
        }
        throw new IllegalArgumentException("Unexpected level [" + level + "]");
    }

    public static String asJULLoggerName(String string) {
        if ("ROOT".equals(string)) {
            return "";
        }
        return string;
    }

    public static java.util.logging.Logger asJULLogger(String string) {
        String string2 = JULHelper.asJULLoggerName(string);
        return java.util.logging.Logger.getLogger(string2);
    }

    public static java.util.logging.Logger asJULLogger(Logger logger) {
        return JULHelper.asJULLogger(logger.getName());
    }
}

