/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.joran.action;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.net.SocketAppender;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import org.xml.sax.Attributes;

public class ConsolePluginAction
extends Action {
    private static final String PORT_ATTR = "port";
    private static final Integer DEFAULT_PORT = 4321;

    public void begin(InterpretationContext interpretationContext, String string, Attributes attributes) {
        String string2 = attributes.getValue(PORT_ATTR);
        Integer n = null;
        if (string2 == null) {
            n = DEFAULT_PORT;
        } else {
            try {
                n = Integer.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.addError("Port " + string2 + " in ConsolePlugin config is not a correct number");
            }
        }
        LoggerContext loggerContext = (LoggerContext)interpretationContext.getContext();
        SocketAppender socketAppender = new SocketAppender();
        socketAppender.setContext((Context)loggerContext);
        socketAppender.setIncludeCallerData(true);
        socketAppender.setRemoteHost("localhost");
        socketAppender.setPort(n);
        socketAppender.start();
        Logger logger = loggerContext.getLogger("ROOT");
        logger.addAppender((Appender<ILoggingEvent>)socketAppender);
        this.addInfo("Sending LoggingEvents to the plugin using port " + n);
    }

    public void end(InterpretationContext interpretationContext, String string) {
    }
}

