/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.joran.action;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.turbo.ReconfigureOnChangeFilter;
import ch.qos.logback.classic.util.EnvUtil;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.status.OnConsoleStatusListener;
import ch.qos.logback.core.util.ContextUtil;
import ch.qos.logback.core.util.Duration;
import ch.qos.logback.core.util.OptionHelper;
import org.xml.sax.Attributes;

public class ConfigurationAction
extends Action {
    static final String INTERNAL_DEBUG_ATTR = "debug";
    static final String SCAN_ATTR = "scan";
    static final String SCAN_PERIOD_ATTR = "scanPeriod";
    static final String DEBUG_SYSTEM_PROPERTY_KEY = "logback.debug";
    long threshold = 0L;

    public void begin(InterpretationContext interpretationContext, String string, Attributes attributes) {
        this.threshold = System.currentTimeMillis();
        String string2 = this.getSystemProperty(DEBUG_SYSTEM_PROPERTY_KEY);
        if (string2 == null) {
            string2 = interpretationContext.subst(attributes.getValue(INTERNAL_DEBUG_ATTR));
        }
        if (OptionHelper.isEmpty((String)string2) || string2.equalsIgnoreCase("false") || string2.equalsIgnoreCase("null")) {
            this.addInfo("debug attribute not set");
        } else {
            OnConsoleStatusListener.addNewInstanceToContext((Context)this.context);
        }
        this.processScanAttrib(interpretationContext, attributes);
        ContextUtil contextUtil = new ContextUtil(this.context);
        contextUtil.addHostNameAsProperty();
        if (EnvUtil.isGroovyAvailable()) {
            LoggerContext loggerContext = (LoggerContext)this.context;
            contextUtil.addGroovyPackages(loggerContext.getFrameworkPackages());
        }
        interpretationContext.pushObject((Object)this.getContext());
    }

    String getSystemProperty(String string) {
        try {
            return System.getProperty(string);
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    void processScanAttrib(InterpretationContext interpretationContext, Attributes attributes) {
        String string = interpretationContext.subst(attributes.getValue(SCAN_ATTR));
        if (!OptionHelper.isEmpty((String)string) && !"false".equalsIgnoreCase(string)) {
            Object object;
            ReconfigureOnChangeFilter reconfigureOnChangeFilter = new ReconfigureOnChangeFilter();
            reconfigureOnChangeFilter.setContext(this.context);
            String string2 = interpretationContext.subst(attributes.getValue(SCAN_PERIOD_ATTR));
            if (!OptionHelper.isEmpty((String)string2)) {
                try {
                    object = Duration.valueOf((String)string2);
                    reconfigureOnChangeFilter.setRefreshPeriod(object.getMilliseconds());
                    this.addInfo("Setting ReconfigureOnChangeFilter scanning period to " + object);
                }
                catch (NumberFormatException numberFormatException) {
                    this.addError("Error while converting [" + string + "] to long", numberFormatException);
                }
            }
            reconfigureOnChangeFilter.start();
            object = (LoggerContext)this.context;
            this.addInfo("Adding ReconfigureOnChangeFilter as a turbo filter");
            ((LoggerContext)((Object)object)).addTurboFilter(reconfigureOnChangeFilter);
        }
    }

    public void end(InterpretationContext interpretationContext, String string) {
        this.addInfo("End of configuration.");
        interpretationContext.popObject();
    }
}

