/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.jmx;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.jmx.JMXConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.status.StatusUtil;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class MBeanUtil {
    static final String DOMAIN = "ch.qos.logback.classic";

    public static String getObjectNameFor(String string, Class clazz) {
        return "ch.qos.logback.classic:Name=" + string + ",Type=" + clazz.getName();
    }

    public static ObjectName string2ObjectName(Context context, Object object, String string) {
        String string2 = "Failed to convert [" + string + "] to ObjectName";
        StatusUtil statusUtil = new StatusUtil(context);
        try {
            return new ObjectName(string);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            statusUtil.addError(object, string2, (Throwable)malformedObjectNameException);
            return null;
        }
        catch (NullPointerException nullPointerException) {
            statusUtil.addError(object, string2, (Throwable)nullPointerException);
            return null;
        }
    }

    public static boolean isRegistered(MBeanServer mBeanServer, ObjectName objectName) {
        return mBeanServer.isRegistered(objectName);
    }

    public static void createAndRegisterJMXConfigurator(MBeanServer mBeanServer, LoggerContext loggerContext, JMXConfigurator jMXConfigurator, ObjectName objectName, Object object) {
        try {
            mBeanServer.registerMBean(jMXConfigurator, objectName);
        }
        catch (Exception exception) {
            StatusUtil statusUtil = new StatusUtil((Context)loggerContext);
            statusUtil.addError(object, "Failed to create mbean", (Throwable)exception);
        }
    }

    public static void unregister(LoggerContext loggerContext, MBeanServer mBeanServer, ObjectName objectName, Object object) {
        StatusUtil statusUtil = new StatusUtil((Context)loggerContext);
        if (mBeanServer.isRegistered(objectName)) {
            try {
                statusUtil.addInfo(object, "Unregistering mbean [" + objectName + "]");
                mBeanServer.unregisterMBean(objectName);
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                statusUtil.addError(object, "Failed to unregister mbean" + objectName, (Throwable)instanceNotFoundException);
            }
            catch (MBeanRegistrationException mBeanRegistrationException) {
                statusUtil.addError(object, "Failed to unregister mbean" + objectName, (Throwable)mBeanRegistrationException);
            }
        } else {
            statusUtil.addInfo(object, "mbean [" + objectName + "] does not seem to be registered");
        }
    }
}

