/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.helpers;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.MDC;

public class MDCInsertingServletFilter
implements Filter {
    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) {
        this.insertIntoMDC(servletRequest);
        try {
            filterChain.doFilter(servletRequest, servletResponse);
        }
        finally {
            this.clearMDC();
        }
    }

    void insertIntoMDC(ServletRequest servletRequest) {
        MDC.put((String)"req.remoteHost", (String)servletRequest.getRemoteHost());
        if (servletRequest instanceof HttpServletRequest) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
            MDC.put((String)"req.requestURI", (String)httpServletRequest.getRequestURI());
            StringBuffer stringBuffer = httpServletRequest.getRequestURL();
            if (stringBuffer != null) {
                MDC.put((String)"req.requestURL", (String)stringBuffer.toString());
            }
            MDC.put((String)"req.method", (String)httpServletRequest.getMethod());
            MDC.put((String)"req.queryString", (String)httpServletRequest.getQueryString());
            MDC.put((String)"req.userAgent", (String)httpServletRequest.getHeader("User-Agent"));
            MDC.put((String)"req.xForwardedFor", (String)httpServletRequest.getHeader("X-Forwarded-For"));
        }
    }

    void clearMDC() {
        MDC.remove((String)"req.remoteHost");
        MDC.remove((String)"req.requestURI");
        MDC.remove((String)"req.queryString");
        MDC.remove((String)"req.requestURL");
        MDC.remove((String)"req.method");
        MDC.remove((String)"req.userAgent");
        MDC.remove((String)"req.xForwardedFor");
    }

    public void init(FilterConfig filterConfig) {
    }
}

