/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.db;

import ch.qos.logback.classic.db.DBHelper;
import ch.qos.logback.classic.db.SQLBuilder;
import ch.qos.logback.classic.db.names.DBNameResolver;
import ch.qos.logback.classic.db.names.DefaultDBNameResolver;
import ch.qos.logback.classic.spi.CallerData;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import ch.qos.logback.core.db.DBAppenderBase;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DBAppender
extends DBAppenderBase<ILoggingEvent> {
    protected String insertPropertiesSQL;
    protected String insertExceptionSQL;
    protected String insertSQL;
    protected static final Method GET_GENERATED_KEYS_METHOD;
    private DBNameResolver dbNameResolver;
    static final int TIMESTMP_INDEX = 1;
    static final int FORMATTED_MESSAGE_INDEX = 2;
    static final int LOGGER_NAME_INDEX = 3;
    static final int LEVEL_STRING_INDEX = 4;
    static final int THREAD_NAME_INDEX = 5;
    static final int REFERENCE_FLAG_INDEX = 6;
    static final int ARG0_INDEX = 7;
    static final int ARG1_INDEX = 8;
    static final int ARG2_INDEX = 9;
    static final int ARG3_INDEX = 10;
    static final int CALLER_FILENAME_INDEX = 11;
    static final int CALLER_CLASS_INDEX = 12;
    static final int CALLER_METHOD_INDEX = 13;
    static final int CALLER_LINE_INDEX = 14;
    static final int EVENT_ID_INDEX = 15;
    static final StackTraceElement EMPTY_CALLER_DATA;

    public void setDbNameResolver(DBNameResolver dBNameResolver) {
        this.dbNameResolver = dBNameResolver;
    }

    public void start() {
        if (this.dbNameResolver == null) {
            this.dbNameResolver = new DefaultDBNameResolver();
        }
        this.insertExceptionSQL = SQLBuilder.buildInsertExceptionSQL(this.dbNameResolver);
        this.insertPropertiesSQL = SQLBuilder.buildInsertPropertiesSQL(this.dbNameResolver);
        this.insertSQL = SQLBuilder.buildInsertSQL(this.dbNameResolver);
        super.start();
    }

    protected void subAppend(ILoggingEvent iLoggingEvent, Connection connection, PreparedStatement preparedStatement) {
        this.bindLoggingEventWithInsertStatement(preparedStatement, iLoggingEvent);
        this.bindLoggingEventArgumentsWithPreparedStatement(preparedStatement, iLoggingEvent.getArgumentArray());
        this.bindCallerDataWithPreparedStatement(preparedStatement, iLoggingEvent.getCallerData());
        int n = preparedStatement.executeUpdate();
        if (n != 1) {
            this.addWarn("Failed to insert loggingEvent");
        }
    }

    protected void secondarySubAppend(ILoggingEvent iLoggingEvent, Connection connection, long l) {
        Map<String, String> map = this.mergePropertyMaps(iLoggingEvent);
        this.insertProperties(map, connection, l);
        if (iLoggingEvent.getThrowableProxy() != null) {
            this.insertThrowable(iLoggingEvent.getThrowableProxy(), connection, l);
        }
    }

    void bindLoggingEventWithInsertStatement(PreparedStatement preparedStatement, ILoggingEvent iLoggingEvent) {
        preparedStatement.setLong(1, iLoggingEvent.getTimeStamp());
        preparedStatement.setString(2, iLoggingEvent.getFormattedMessage());
        preparedStatement.setString(3, iLoggingEvent.getLoggerName());
        preparedStatement.setString(4, iLoggingEvent.getLevel().toString());
        preparedStatement.setString(5, iLoggingEvent.getThreadName());
        preparedStatement.setShort(6, DBHelper.computeReferenceMask(iLoggingEvent));
    }

    void bindLoggingEventArgumentsWithPreparedStatement(PreparedStatement preparedStatement, Object[] objectArray) {
        int n;
        int n2 = objectArray != null ? objectArray.length : 0;
        for (n = 0; n < n2 && n < 4; ++n) {
            preparedStatement.setString(7 + n, this.asStringTruncatedTo254(objectArray[n]));
        }
        if (n2 < 4) {
            for (n = n2; n < 4; ++n) {
                preparedStatement.setString(7 + n, null);
            }
        }
    }

    String asStringTruncatedTo254(Object object) {
        String string = null;
        if (object != null) {
            string = object.toString();
        }
        if (string == null) {
            return null;
        }
        if (string.length() <= 254) {
            return string;
        }
        return string.substring(0, 254);
    }

    void bindCallerDataWithPreparedStatement(PreparedStatement preparedStatement, StackTraceElement[] stackTraceElementArray) {
        StackTraceElement stackTraceElement = this.extractFirstCaller(stackTraceElementArray);
        preparedStatement.setString(11, stackTraceElement.getFileName());
        preparedStatement.setString(12, stackTraceElement.getClassName());
        preparedStatement.setString(13, stackTraceElement.getMethodName());
        preparedStatement.setString(14, Integer.toString(stackTraceElement.getLineNumber()));
    }

    private StackTraceElement extractFirstCaller(StackTraceElement[] stackTraceElementArray) {
        StackTraceElement stackTraceElement = EMPTY_CALLER_DATA;
        if (this.hasAtLeastOneNonNullElement(stackTraceElementArray)) {
            stackTraceElement = stackTraceElementArray[0];
        }
        return stackTraceElement;
    }

    private boolean hasAtLeastOneNonNullElement(StackTraceElement[] stackTraceElementArray) {
        return stackTraceElementArray != null && stackTraceElementArray.length > 0 && stackTraceElementArray[0] != null;
    }

    Map<String, String> mergePropertyMaps(ILoggingEvent iLoggingEvent) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Map<String, String> map = iLoggingEvent.getLoggerContextVO().getPropertyMap();
        Map<String, String> map2 = iLoggingEvent.getMDCPropertyMap();
        if (map != null) {
            hashMap.putAll(map);
        }
        if (map2 != null) {
            hashMap.putAll(map2);
        }
        return hashMap;
    }

    protected Method getGeneratedKeysMethod() {
        return GET_GENERATED_KEYS_METHOD;
    }

    protected String getInsertSQL() {
        return this.insertSQL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertProperties(Map<String, String> map, Connection connection, long l) {
        Set<String> set = map.keySet();
        if (set.size() > 0) {
            PreparedStatement preparedStatement;
            block5: {
                preparedStatement = null;
                try {
                    preparedStatement = connection.prepareStatement(this.insertPropertiesSQL);
                    for (String string : set) {
                        String string2 = map.get(string);
                        preparedStatement.setLong(1, l);
                        preparedStatement.setString(2, string);
                        preparedStatement.setString(3, string2);
                        if (this.cnxSupportsBatchUpdates) {
                            preparedStatement.addBatch();
                            continue;
                        }
                        preparedStatement.execute();
                    }
                    if (!this.cnxSupportsBatchUpdates) break block5;
                    preparedStatement.executeBatch();
                }
                catch (Throwable throwable) {
                    ch.qos.logback.core.db.DBHelper.closeStatement(preparedStatement);
                    throw throwable;
                }
            }
            ch.qos.logback.core.db.DBHelper.closeStatement((Statement)preparedStatement);
        }
    }

    void updateExceptionStatement(PreparedStatement preparedStatement, String string, short s, long l) {
        preparedStatement.setLong(1, l);
        preparedStatement.setShort(2, s);
        preparedStatement.setString(3, string);
        if (this.cnxSupportsBatchUpdates) {
            preparedStatement.addBatch();
        } else {
            preparedStatement.execute();
        }
    }

    short buildExceptionStatement(IThrowableProxy iThrowableProxy, short s, PreparedStatement preparedStatement, long l) {
        StringBuilder stringBuilder = new StringBuilder();
        ThrowableProxyUtil.subjoinFirstLine(stringBuilder, iThrowableProxy);
        short s2 = s;
        s = (short)(s + 1);
        this.updateExceptionStatement(preparedStatement, stringBuilder.toString(), s2, l);
        int n = iThrowableProxy.getCommonFrames();
        StackTraceElementProxy[] stackTraceElementProxyArray = iThrowableProxy.getStackTraceElementProxyArray();
        for (int i = 0; i < stackTraceElementProxyArray.length - n; ++i) {
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder2.append('\t');
            ThrowableProxyUtil.subjoinSTEP(stringBuilder2, stackTraceElementProxyArray[i]);
            short s3 = s;
            s = (short)(s + 1);
            this.updateExceptionStatement(preparedStatement, stringBuilder2.toString(), s3, l);
        }
        if (n > 0) {
            StringBuilder stringBuilder3 = new StringBuilder();
            stringBuilder3.append('\t').append("... ").append(n).append(" common frames omitted");
            short s4 = s;
            s = (short)(s + 1);
            this.updateExceptionStatement(preparedStatement, stringBuilder3.toString(), s4, l);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertThrowable(IThrowableProxy iThrowableProxy, Connection connection, long l) {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.insertExceptionSQL);
            short s = 0;
            while (iThrowableProxy != null) {
                s = this.buildExceptionStatement(iThrowableProxy, s, preparedStatement, l);
                iThrowableProxy = iThrowableProxy.getCause();
            }
            if (this.cnxSupportsBatchUpdates) {
                preparedStatement.executeBatch();
            }
        }
        catch (Throwable throwable) {
            ch.qos.logback.core.db.DBHelper.closeStatement(preparedStatement);
            throw throwable;
        }
        ch.qos.logback.core.db.DBHelper.closeStatement((Statement)preparedStatement);
    }

    static {
        Method method;
        EMPTY_CALLER_DATA = CallerData.naInstance();
        try {
            method = PreparedStatement.class.getMethod("getGeneratedKeys", null);
        }
        catch (Exception exception) {
            method = null;
        }
        GET_GENERATED_KEYS_METHOD = method;
    }
}

