/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.boolex;

import ch.qos.logback.classic.boolex.IEvaluator;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.boolex.EventEvaluatorBase;
import ch.qos.logback.core.util.FileUtil;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import groovy.lang.Script;
import org.codehaus.groovy.control.CompilationFailedException;

public class GEventEvaluator
extends EventEvaluatorBase<ILoggingEvent> {
    String expression;
    IEvaluator delegateEvaluator;
    Script script;

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String string) {
        this.expression = string;
    }

    public void start() {
        int n = 0;
        if (this.expression == null || this.expression.length() == 0) {
            this.addError("Empty expression");
            return;
        }
        this.addInfo("Expression to evaluate [" + this.expression + "]");
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        String string = ((Object)((Object)this)).getClass().getPackage().getName();
        string = string.replace('.', '/');
        FileUtil fileUtil = new FileUtil(this.getContext());
        String string2 = fileUtil.resourceAsString(classLoader, string + "/EvaluatorTemplate.groovy");
        if (string2 == null) {
            return;
        }
        string2 = string2.replace("//EXPRESSION", this.expression);
        GroovyClassLoader groovyClassLoader = new GroovyClassLoader(classLoader);
        try {
            Class clazz = groovyClassLoader.parseClass(string2);
            GroovyObject groovyObject = (GroovyObject)clazz.newInstance();
            this.delegateEvaluator = (IEvaluator)groovyObject;
        }
        catch (CompilationFailedException compilationFailedException) {
            this.addError("Failed to compile expression [" + this.expression + "]", compilationFailedException);
            ++n;
        }
        catch (Exception exception) {
            this.addError("Failed to compile expression [" + this.expression + "]", exception);
            ++n;
        }
        if (n == 0) {
            super.start();
        }
    }

    public boolean evaluate(ILoggingEvent iLoggingEvent) {
        if (this.delegateEvaluator == null) {
            return false;
        }
        return this.delegateEvaluator.doEvaluate(iLoggingEvent);
    }
}

