/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.slf4j.helpers.Util;

class Log4jLoggerFactory {
    private static ConcurrentMap<String, Logger> log4jLoggers = new ConcurrentHashMap<String, Logger>();
    private static final String LOG4J_DELEGATION_LOOP_URL = "http://www.slf4j.org/codes.html#log4jDelegationLoop";

    Log4jLoggerFactory() {
    }

    public static Logger getLogger(String string) {
        Logger logger = (Logger)log4jLoggers.get(string);
        if (logger != null) {
            return logger;
        }
        Logger logger2 = new Logger(string);
        Logger logger3 = log4jLoggers.putIfAbsent(string, logger2);
        return logger3 == null ? logger2 : logger3;
    }

    public static Logger getLogger(String string, LoggerFactory loggerFactory) {
        Logger logger = (Logger)log4jLoggers.get(string);
        if (logger != null) {
            return logger;
        }
        Logger logger2 = loggerFactory.makeNewLoggerInstance(string);
        Logger logger3 = log4jLoggers.putIfAbsent(string, logger2);
        return logger3 == null ? logger2 : logger3;
    }

    static {
        try {
            Class.forName("org.slf4j.impl.Log4jLoggerFactory");
            String string = "Detected both log4j-over-slf4j.jar AND slf4j-log4j12.jar on the class path, preempting StackOverflowError. ";
            String string2 = "See also http://www.slf4j.org/codes.html#log4jDelegationLoop for more details.";
            Util.report((String)string);
            Util.report((String)string2);
            throw new IllegalStateException(string + string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return;
        }
    }
}

