/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.bridge;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.spi.LocationAwareLogger;

public class SLF4JBridgeHandler
extends Handler {
    private static final String FQCN = java.util.logging.Logger.class.getName();
    private static final String UNKNOWN_LOGGER_NAME = "unknown.jul.logger";
    private static final int TRACE_LEVEL_THRESHOLD = Level.FINEST.intValue();
    private static final int DEBUG_LEVEL_THRESHOLD = Level.FINE.intValue();
    private static final int INFO_LEVEL_THRESHOLD = Level.INFO.intValue();
    private static final int WARN_LEVEL_THRESHOLD = Level.WARNING.intValue();

    public static void install() {
        LogManager.getLogManager().getLogger("").addHandler(new SLF4JBridgeHandler());
    }

    private static java.util.logging.Logger getRootLogger() {
        return LogManager.getLogManager().getLogger("");
    }

    public static void uninstall() {
        java.util.logging.Logger logger = SLF4JBridgeHandler.getRootLogger();
        Handler[] handlerArray = logger.getHandlers();
        for (int i = 0; i < handlerArray.length; ++i) {
            if (!(handlerArray[i] instanceof SLF4JBridgeHandler)) continue;
            logger.removeHandler(handlerArray[i]);
        }
    }

    public static boolean isInstalled() {
        java.util.logging.Logger logger = SLF4JBridgeHandler.getRootLogger();
        Handler[] handlerArray = logger.getHandlers();
        for (int i = 0; i < handlerArray.length; ++i) {
            if (!(handlerArray[i] instanceof SLF4JBridgeHandler)) continue;
            return true;
        }
        return false;
    }

    public static void removeHandlersForRootLogger() {
        java.util.logging.Logger logger = SLF4JBridgeHandler.getRootLogger();
        Handler[] handlerArray = logger.getHandlers();
        for (int i = 0; i < handlerArray.length; ++i) {
            logger.removeHandler(handlerArray[i]);
        }
    }

    public void close() {
    }

    public void flush() {
    }

    protected Logger getSLF4JLogger(LogRecord logRecord) {
        String string = logRecord.getLoggerName();
        if (string == null) {
            string = UNKNOWN_LOGGER_NAME;
        }
        return LoggerFactory.getLogger((String)string);
    }

    protected void callLocationAwareLogger(LocationAwareLogger locationAwareLogger, LogRecord logRecord) {
        int n = logRecord.getLevel().intValue();
        int n2 = n <= TRACE_LEVEL_THRESHOLD ? 0 : (n <= DEBUG_LEVEL_THRESHOLD ? 10 : (n <= INFO_LEVEL_THRESHOLD ? 20 : (n <= WARN_LEVEL_THRESHOLD ? 30 : 40)));
        String string = this.getMessageI18N(logRecord);
        locationAwareLogger.log(null, FQCN, n2, string, null, logRecord.getThrown());
    }

    protected void callPlainSLF4JLogger(Logger logger, LogRecord logRecord) {
        String string = this.getMessageI18N(logRecord);
        int n = logRecord.getLevel().intValue();
        if (n <= TRACE_LEVEL_THRESHOLD) {
            logger.trace(string, logRecord.getThrown());
        } else if (n <= DEBUG_LEVEL_THRESHOLD) {
            logger.debug(string, logRecord.getThrown());
        } else if (n <= INFO_LEVEL_THRESHOLD) {
            logger.info(string, logRecord.getThrown());
        } else if (n <= WARN_LEVEL_THRESHOLD) {
            logger.warn(string, logRecord.getThrown());
        } else {
            logger.error(string, logRecord.getThrown());
        }
    }

    private String getMessageI18N(LogRecord logRecord) {
        Object[] objectArray;
        String string = logRecord.getMessage();
        if (string == null) {
            return null;
        }
        ResourceBundle resourceBundle = logRecord.getResourceBundle();
        if (resourceBundle != null) {
            try {
                string = resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if ((objectArray = logRecord.getParameters()) != null && objectArray.length > 0) {
            string = MessageFormat.format(string, objectArray);
        }
        return string;
    }

    public void publish(LogRecord logRecord) {
        if (logRecord == null) {
            return;
        }
        Logger logger = this.getSLF4JLogger(logRecord);
        String string = logRecord.getMessage();
        if (string == null) {
            string = "";
        }
        if (logger instanceof LocationAwareLogger) {
            this.callLocationAwareLogger((LocationAwareLogger)logger, logRecord);
        } else {
            this.callPlainSLF4JLogger(logger, logRecord);
        }
    }
}

